/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.util.Utilities;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.logging.Logging;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int MIN_CAPACITY = 7;
    private static final float LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int count;
    private int threshold;
    private long lastRehashTime;
    private static final long HOLD_TIME = 20000L;

    public WeakValueHashMap() {
        this(7);
    }

    public WeakValueHashMap(int n) {
        this.newEntryTable(n);
        this.threshold = Math.round((float)this.table.length * 0.75f);
        this.lastRehashTime = System.currentTimeMillis();
    }

    private void newEntryTable(int n) {
        this.table = (Entry[])Array.newInstance(Entry.class, n);
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.valid()) : this.count;
        int n = entry.index;
        if (n < this.table.length) {
            Entry entry2 = null;
            Entry entry3 = this.table[n];
            while (entry3 != null) {
                if (entry3 == entry) {
                    if (entry2 != null) {
                        entry2.next = entry3.next;
                    } else {
                        this.table[n] = entry3.next;
                    }
                    --this.count;
                    assert (this.valid());
                    if (this.count <= this.threshold / 4) {
                        this.rehash(false);
                    }
                    return;
                }
                entry2 = entry3;
                entry3 = entry3.next;
            }
        }
        assert (this.valid());
    }

    private void rehash(boolean bl) {
        Object object;
        Object object2;
        assert (Thread.holdsLock(this));
        assert (this.valid());
        long l = System.currentTimeMillis();
        int n = Math.max(Math.round((float)this.count / 0.375f), this.count + 7);
        if (bl ? n <= this.table.length : n >= this.table.length || l - this.lastRehashTime < 20000L) {
            return;
        }
        this.lastRehashTime = l;
        Entry[] entryArray = this.table;
        this.newEntryTable(n);
        this.threshold = Math.round((float)n * 0.75f);
        for (int i = 0; i < entryArray.length; ++i) {
            object2 = entryArray[i];
            while (object2 != null) {
                object = object2;
                object2 = ((Entry)object2).next;
                Object k = ((Entry)object).key;
                if (k != null) {
                    int n2;
                    ((Entry)object).index = n2 = (k.hashCode() & Integer.MAX_VALUE) % this.table.length;
                    ((Entry)object).next = this.table[n2];
                    this.table[n2] = object;
                    continue;
                }
                --this.count;
            }
        }
        Logger logger = Logging.getLogger("org.geotools.util");
        if (logger.isLoggable((Level)(object2 = Level.FINEST))) {
            object = new LogRecord((Level)object2, "Rehash from " + entryArray.length + " to " + this.table.length);
            ((LogRecord)object).setSourceMethodName(bl ? "unique" : "remove");
            ((LogRecord)object).setSourceClassName(WeakValueHashMap.class.getName());
            ((LogRecord)object).setLoggerName(logger.getName());
            logger.log((LogRecord)object);
        }
        assert (this.valid());
    }

    private boolean valid() {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                ++n;
                entry = entry.next;
            }
        }
        if (n != this.count) {
            this.count = n;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int size() {
        assert (this.valid());
        return this.count;
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public synchronized V get(Object object) {
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        int n = (object.hashCode() & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[n];
        while (entry != null) {
            if (object.equals(entry.key)) {
                return (V)entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    private synchronized V intern(K k, V v) {
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        V v2 = null;
        int n = k.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (k.equals(entry.key)) {
                v2 = (V)entry.get();
                entry.clear();
            }
            entry = entry.next;
        }
        if (v != null) {
            if (this.count >= this.threshold) {
                this.rehash(true);
                n2 = n % this.table.length;
            }
            this.table[n2] = new Entry(k, v, this.table[n2], n2);
            ++this.count;
        }
        assert (this.valid());
        return v2;
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException("Null value not allowed");
        }
        return this.intern(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.intern(object, null);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private final class Entry
    extends WeakReference<V>
    implements Map.Entry<K, V> {
        K key;
        Entry next;
        int index;

        Entry(K k, V v, Entry entry, int n) {
            super(v, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.key = k;
            this.next = entry;
            this.index = n;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V v) {
            if (v != null) {
                throw new UnsupportedOperationException();
            }
            Object t = this.get();
            this.clear();
            return t;
        }

        @Override
        public void clear() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
            this.key = null;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return Utilities.equals(this.getKey(), entry.getKey()) && Utilities.equals(this.getValue(), entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object t = this.get();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (t == null ? 0 : t.hashCode());
        }
    }
}

