/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.geotools.util.SynchronizedIterator;
import org.opengis.util.Cloneable;

public class CheckedArrayList<E>
extends ArrayList<E>
implements CheckedCollection<E>,
Cloneable {
    private static final long serialVersionUID = -587331971085094268L;
    private final Class<E> type;

    public CheckedArrayList(Class<E> clazz) {
        this.type = clazz;
        this.ensureNonNull();
    }

    public CheckedArrayList(Class<E> clazz, int n) {
        super(n);
        this.type = clazz;
        this.ensureNonNull();
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    private void ensureNonNull() {
        if (this.type == null) {
            throw new IllegalArgumentException(Errors.format(143, "type"));
        }
    }

    protected void ensureValidType(E e) throws IllegalArgumentException {
        if (e != null && !this.type.isInstance(e)) {
            throw new IllegalArgumentException(Errors.format(61, e.getClass(), this.type));
        }
    }

    private void ensureValid(Collection<? extends E> collection) throws IllegalArgumentException {
        if (collection != null) {
            for (E e : collection) {
                this.ensureValidType(e);
            }
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object;
        Object object2 = object = this.getLock();
        synchronized (object2) {
            return new SynchronizedIterator(super.iterator(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.lastIndexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int n) {
        Object object = this.getLock();
        synchronized (object) {
            return super.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidType(e);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.set(n, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidType(e);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, E e) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidType(e);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.add(n, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(n, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) throws UnsupportedOperationException {
        Object object2 = this.getLock();
        synchronized (object2) {
            this.checkWritePermission();
            return super.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.retainAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trimToSize() {
        Object object = this.getLock();
        synchronized (object) {
            super.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureCapacity(int n) {
        Object object = this.getLock();
        synchronized (object) {
            super.ensureCapacity(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray(TArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.equals(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedArrayList<E> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedArrayList)super.clone();
        }
    }
}

