/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.measure.Latitude;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class LambertConformal
extends MapProjection {
    private static final long serialVersionUID = 1275881689637308614L;
    private static final double EPSILON = 1.0E-6;
    private static final double BELGE_A = 1.42043136359877E-4;
    private final double phi1;
    private final double phi2;
    private final double n;
    private final double F;
    private final double rho0;
    private final boolean belgium;

    protected LambertConformal(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        this(parameterValueGroup, false);
    }

    LambertConformal(ParameterValueGroup parameterValueGroup, boolean bl) throws ParameterNotFoundException {
        super(parameterValueGroup);
        boolean bl2;
        double d;
        List<GeneralParameterDescriptor> list = this.getParameterDescriptors().descriptors();
        boolean bl3 = list.contains(MapProjection.AbstractProvider.STANDARD_PARALLEL_2);
        this.belgium = bl;
        if (bl3) {
            this.phi1 = this.doubleValue(list, MapProjection.AbstractProvider.STANDARD_PARALLEL_1, parameterValueGroup);
            LambertConformal.ensureLatitudeInRange(MapProjection.AbstractProvider.STANDARD_PARALLEL_1, this.phi1, true);
            d = this.doubleValue(list, MapProjection.AbstractProvider.STANDARD_PARALLEL_2, parameterValueGroup);
            if (Double.isNaN(d)) {
                d = this.phi1;
            }
            this.phi2 = d;
            LambertConformal.ensureLatitudeInRange(MapProjection.AbstractProvider.STANDARD_PARALLEL_2, d, true);
        } else {
            if (bl) {
                throw new IllegalArgumentException();
            }
            this.phi1 = this.phi2 = this.latitudeOfOrigin;
        }
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-6) {
            throw new IllegalArgumentException(Errors.format(5, new Latitude(Math.toDegrees(this.phi1)), new Latitude(Math.toDegrees(this.phi2))));
        }
        d = Math.cos(this.phi1);
        double d2 = Math.sin(this.phi1);
        boolean bl4 = bl2 = Math.abs(this.phi1 - this.phi2) > 1.0E-6;
        if (this.isSpherical) {
            this.n = bl2 ? Math.log(d / Math.cos(this.phi2)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * this.phi2) / Math.tan(0.7853981633974483 + 0.5 * this.phi1)) : d2;
            this.F = d * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.phi1), this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.latitudeOfOrigin), -this.n) : 0.0;
        } else {
            double d3 = this.msfn(d2, d);
            double d4 = this.tsfn(this.phi1, d2);
            if (bl2) {
                double d5 = Math.sin(this.phi2);
                double d6 = this.msfn(d5, Math.cos(this.phi2));
                double d7 = this.tsfn(this.phi2, d5);
                this.n = Math.log(d3 / d6) / Math.log(d4 / d7);
            } else {
                this.n = d2;
            }
            this.F = d3 * Math.pow(d4, -this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(this.tsfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin)), this.n) : 0.0;
        }
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = super.getParameterValues();
        List<GeneralParameterDescriptor> list = this.getParameterDescriptors().descriptors();
        this.set(list, MapProjection.AbstractProvider.STANDARD_PARALLEL_1, parameterValueGroup, this.phi1);
        this.set(list, MapProjection.AbstractProvider.STANDARD_PARALLEL_2, parameterValueGroup, this.phi2);
        return parameterValueGroup;
    }

    @Override
    protected Point2D transformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
        double d3;
        if (Math.abs(Math.abs(d2) - 1.5707963267948966) < 1.0E-6) {
            if (d2 * this.n <= 0.0) {
                throw new ProjectionException(d2);
            }
            d3 = 0.0;
        } else {
            d3 = this.isSpherical ? this.F * Math.pow(Math.tan(0.7853981633974483 + 0.5 * d2), -this.n) : this.F * Math.pow(this.tsfn(d2, Math.sin(d2)), this.n);
        }
        d *= this.n;
        if (this.belgium) {
            d -= 1.42043136359877E-4;
        }
        d2 = this.rho0 - d3 * Math.cos(d);
        d = d3 * Math.sin(d);
        if (point2D != null) {
            point2D.setLocation(d, d2);
            return point2D;
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    protected Point2D inverseTransformNormalized(double d, double d2, Point2D point2D) throws ProjectionException {
        double d3 = Math.hypot(d, d2 = this.rho0 - d2);
        if (d3 > 1.0E-6) {
            if (this.n < 0.0) {
                d3 = -d3;
                d = -d;
                d2 = -d2;
            }
            double d4 = Math.atan2(d, d2);
            if (this.belgium) {
                d4 += 1.42043136359877E-4;
            }
            d = d4 / this.n;
            d2 = this.isSpherical ? 2.0 * Math.atan(Math.pow(this.F / d3, 1.0 / this.n)) - 1.5707963267948966 : this.cphi2(Math.pow(d3 / this.F, 1.0 / this.n));
        } else {
            d = 0.0;
            double d5 = d2 = this.n < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (point2D != null) {
            point2D.setLocation(d, d2);
            return point2D;
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.F);
        return ((int)l ^ (int)(l >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LambertConformal lambertConformal = (LambertConformal)object;
            return this.belgium == lambertConformal.belgium && LambertConformal.equals(this.n, lambertConformal.n) && LambertConformal.equals(this.F, lambertConformal.F) && LambertConformal.equals(this.rho0, lambertConformal.rho0) && LambertConformal.equals(this.phi1, lambertConformal.phi1) && LambertConformal.equals(this.phi2, lambertConformal.phi2);
        }
        return false;
    }
}

