/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.geotools.resources.i18n.Errors;

public class XAffineTransform
extends AffineTransform {
    private static final long serialVersionUID = 5215291166450556451L;

    public XAffineTransform(AffineTransform affineTransform) {
        super(affineTransform);
    }

    protected void checkPermission() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format(188));
    }

    @Override
    public void translate(double d, double d2) {
        this.checkPermission();
        super.translate(d, d2);
    }

    @Override
    public void rotate(double d) {
        this.checkPermission();
        super.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.checkPermission();
        super.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.checkPermission();
        super.scale(d, d2);
    }

    @Override
    public void shear(double d, double d2) {
        this.checkPermission();
        super.shear(d, d2);
    }

    @Override
    public void setToIdentity() {
        this.checkPermission();
        super.setToIdentity();
    }

    @Override
    public void setToTranslation(double d, double d2) {
        this.checkPermission();
        super.setToTranslation(d, d2);
    }

    @Override
    public void setToRotation(double d) {
        this.checkPermission();
        super.setToRotation(d);
    }

    @Override
    public void setToRotation(double d, double d2, double d3) {
        this.checkPermission();
        super.setToRotation(d, d2, d3);
    }

    @Override
    public void setToScale(double d, double d2) {
        this.checkPermission();
        super.setToScale(d, d2);
    }

    @Override
    public void setToShear(double d, double d2) {
        this.checkPermission();
        super.setToShear(d, d2);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.checkPermission();
        super.setTransform(affineTransform);
    }

    @Override
    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.checkPermission();
        super.setTransform(d, d2, d3, d4, d5, d6);
    }

    @Override
    public void concatenate(AffineTransform affineTransform) {
        this.checkPermission();
        super.concatenate(affineTransform);
    }

    @Override
    public void preConcatenate(AffineTransform affineTransform) {
        this.checkPermission();
        super.preConcatenate(affineTransform);
    }

    public boolean isIdentity(double d) {
        return XAffineTransform.isIdentity(this, d);
    }

    public static boolean isIdentity(AffineTransform affineTransform, double d) {
        if (affineTransform.isIdentity()) {
            return true;
        }
        d = Math.abs(d);
        return Math.abs(affineTransform.getScaleX() - 1.0) <= d && Math.abs(affineTransform.getScaleY() - 1.0) <= d && Math.abs(affineTransform.getShearX()) <= d && Math.abs(affineTransform.getShearY()) <= d && Math.abs(affineTransform.getTranslateX()) <= d && Math.abs(affineTransform.getTranslateY()) <= d;
    }

    public static Shape transform(AffineTransform affineTransform, Shape shape, boolean bl) {
        int n = affineTransform.getType();
        if (n == 0) {
            return shape;
        }
        if ((n & 0x30) == 0) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                return XAffineTransform.transform(affineTransform, rectangle2D, bl ? rectangle2D : null);
            }
            if ((n & 0) == 0 && shape instanceof RectangularShape) {
                RectangularShape rectangularShape = (RectangularShape)shape;
                if (!bl) {
                    rectangularShape = (RectangularShape)rectangularShape.clone();
                }
                Rectangle2D rectangle2D = rectangularShape.getFrame();
                rectangularShape.setFrame(XAffineTransform.transform(affineTransform, rectangle2D, rectangle2D));
                return rectangularShape;
            }
        }
        if (shape instanceof GeneralPath) {
            GeneralPath generalPath = (GeneralPath)shape;
            if (bl) {
                generalPath.transform(affineTransform);
            } else {
                shape = generalPath.createTransformedShape(affineTransform);
            }
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            if (bl) {
                area.transform(affineTransform);
            } else {
                shape = area.createTransformedArea(affineTransform);
            }
        } else {
            GeneralPath generalPath = new GeneralPath(shape);
            generalPath.transform(affineTransform);
            shape = generalPath;
        }
        return shape;
    }

    public static Rectangle2D transform(AffineTransform affineTransform, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            affineTransform.transform(double_, double_);
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
            return rectangle2D2;
        }
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }
}

