/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.measure.converter.ConversionException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.DefaultConcatenatedOperation;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.CanonicalSet;
import org.geotools.util.Utilities;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;

public abstract class AbstractCoordinateOperationFactory
extends ReferencingFactory
implements CoordinateOperationFactory {
    protected static final ReferenceIdentifier IDENTITY = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(102));
    protected static final ReferenceIdentifier AXIS_CHANGES = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(7));
    protected static final ReferenceIdentifier DATUM_SHIFT = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(40));
    protected static final ReferenceIdentifier ELLIPSOID_SHIFT = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(59));
    protected static final ReferenceIdentifier GEOCENTRIC_CONVERSION = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(79));
    protected static final ReferenceIdentifier INVERSE_OPERATION = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(113));
    private final ReferencingFactoryContainer factories;
    private final MathTransformFactory mtFactory;
    private final CanonicalSet<CoordinateOperation> pool = CanonicalSet.newInstance(CoordinateOperation.class);
    private boolean hintsInitialized;

    public AbstractCoordinateOperationFactory(Hints hints, int n) {
        super(n);
        this.factories = ReferencingFactoryContainer.instance(hints);
        this.mtFactory = this.factories.getMathTransformFactory();
    }

    AbstractCoordinateOperationFactory(CoordinateOperationFactory coordinateOperationFactory, Hints hints, int n) {
        super(n);
        this.factories = coordinateOperationFactory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)coordinateOperationFactory).getFactoryContainer() : ReferencingFactoryContainer.instance(hints);
        this.mtFactory = this.factories.getMathTransformFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (!this.hintsInitialized) {
                this.initializeHints();
                this.hintsInitialized = true;
            }
        }
        return super.getImplementationHints();
    }

    void initializeHints() {
        assert (Thread.holdsLock(this.hints));
        ReferencingFactoryContainer referencingFactoryContainer = this.getFactoryContainer();
        this.hints.putAll(referencingFactoryContainer.getImplementationHints());
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.mtFactory;
    }

    final ReferencingFactoryContainer getFactoryContainer() {
        return this.factories;
    }

    protected Matrix swapAndScaleAxis(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws OperationNotFoundException {
        try {
            return AbstractCS.swapAndScaleAxis(coordinateSystem, coordinateSystem2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage(coordinateSystem, coordinateSystem2), illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage(coordinateSystem, coordinateSystem2), conversionException);
        }
    }

    private static Map<String, Object> getProperties(ReferenceIdentifier referenceIdentifier) {
        HashMap<String, Object> hashMap;
        if (referenceIdentifier == DATUM_SHIFT || referenceIdentifier == ELLIPSOID_SHIFT) {
            hashMap = new HashMap<String, ReferenceIdentifier>(4);
            hashMap.put("name", referenceIdentifier);
            hashMap.put("coordinateOperationAccuracy", new PositionalAccuracy[]{referenceIdentifier == DATUM_SHIFT ? PositionalAccuracyImpl.DATUM_SHIFT_APPLIED : PositionalAccuracyImpl.DATUM_SHIFT_OMITTED});
        } else {
            hashMap = Collections.singletonMap("name", referenceIdentifier);
        }
        return hashMap;
    }

    protected CoordinateOperation createFromAffineTransform(ReferenceIdentifier referenceIdentifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Matrix matrix) throws FactoryException {
        MathTransform mathTransform = this.mtFactory.createAffineTransform(matrix);
        Map<String, Object> map = AbstractCoordinateOperationFactory.getProperties(referenceIdentifier);
        Class clazz = map.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, ProjectiveTransform.ProviderAffine.getProvider(mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions()), clazz);
    }

    protected CoordinateOperation createFromParameters(ReferenceIdentifier referenceIdentifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Map<String, Object> map = AbstractCoordinateOperationFactory.getProperties(referenceIdentifier);
        MathTransform mathTransform = this.mtFactory.createParameterizedTransform(parameterValueGroup);
        OperationMethod operationMethod = this.mtFactory.getLastMethodUsed();
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod, Operation.class);
    }

    protected CoordinateOperation createFromMathTransform(ReferenceIdentifier referenceIdentifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) throws FactoryException {
        return this.createFromMathTransform(Collections.singletonMap("name", referenceIdentifier), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, null, CoordinateOperation.class);
    }

    protected CoordinateOperation createFromMathTransform(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod, Class<? extends CoordinateOperation> clazz) throws FactoryException {
        CoordinateOperation coordinateOperation;
        if (mathTransform instanceof CoordinateOperation && Utilities.equals((coordinateOperation = (CoordinateOperation)((Object)mathTransform)).getSourceCRS(), coordinateReferenceSystem) && Utilities.equals(coordinateOperation.getTargetCRS(), coordinateReferenceSystem2) && Utilities.equals(coordinateOperation.getMathTransform(), mathTransform)) {
            if (coordinateOperation instanceof Operation) {
                if (Utilities.equals(((Operation)coordinateOperation).getMethod(), operationMethod)) {
                    return coordinateOperation;
                }
            } else {
                return coordinateOperation;
            }
        }
        coordinateOperation = DefaultOperation.create(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod, clazz);
        coordinateOperation = this.pool.unique(coordinateOperation);
        return coordinateOperation;
    }

    @Override
    public CoordinateOperation createConcatenatedOperation(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray) throws FactoryException {
        CoordinateOperation coordinateOperation = new DefaultConcatenatedOperation(map, coordinateOperationArray, this.mtFactory);
        coordinateOperation = this.pool.unique(coordinateOperation);
        return coordinateOperation;
    }

    protected CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2) throws FactoryException {
        if (coordinateOperation == null) {
            return coordinateOperation2;
        }
        if (coordinateOperation2 == null) {
            return coordinateOperation;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation)) {
            return coordinateOperation2;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation2)) {
            return coordinateOperation;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        MathTransform mathTransform2 = coordinateOperation2.getMathTransform();
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation2.getTargetCRS();
        CoordinateOperation coordinateOperation3 = null;
        if (coordinateOperation.getName() == AXIS_CHANGES && mathTransform.getSourceDimensions() == mathTransform.getTargetDimensions()) {
            coordinateOperation3 = coordinateOperation2;
        }
        if (coordinateOperation2.getName() == AXIS_CHANGES && mathTransform2.getSourceDimensions() == mathTransform2.getTargetDimensions()) {
            coordinateOperation3 = coordinateOperation;
        }
        if (coordinateOperation3 instanceof Operation) {
            return this.createFromMathTransform(AbstractIdentifiedObject.getProperties(coordinateOperation3), coordinateReferenceSystem, coordinateReferenceSystem2, this.mtFactory.createConcatenatedTransform(mathTransform, mathTransform2), ((Operation)coordinateOperation3).getMethod(), CoordinateOperation.class);
        }
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem, coordinateReferenceSystem2), new CoordinateOperation[]{coordinateOperation, coordinateOperation2});
    }

    protected CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2, CoordinateOperation coordinateOperation3) throws FactoryException {
        if (coordinateOperation == null) {
            return this.concatenate(coordinateOperation2, coordinateOperation3);
        }
        if (coordinateOperation2 == null) {
            return this.concatenate(coordinateOperation, coordinateOperation3);
        }
        if (coordinateOperation3 == null) {
            return this.concatenate(coordinateOperation, coordinateOperation2);
        }
        assert (CRS.equalsIgnoreMetadata(coordinateOperation.getTargetCRS(), coordinateOperation2.getSourceCRS())) : coordinateOperation;
        assert (CRS.equalsIgnoreMetadata(coordinateOperation2.getTargetCRS(), coordinateOperation3.getSourceCRS())) : coordinateOperation3;
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation)) {
            return this.concatenate(coordinateOperation2, coordinateOperation3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation2)) {
            return this.concatenate(coordinateOperation, coordinateOperation3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(coordinateOperation3)) {
            return this.concatenate(coordinateOperation, coordinateOperation2);
        }
        if (coordinateOperation.getName() == AXIS_CHANGES) {
            return this.concatenate(this.concatenate(coordinateOperation, coordinateOperation2), coordinateOperation3);
        }
        if (coordinateOperation3.getName() == AXIS_CHANGES) {
            return this.concatenate(coordinateOperation, this.concatenate(coordinateOperation2, coordinateOperation3));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation3.getTargetCRS();
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem, coordinateReferenceSystem2), new CoordinateOperation[]{coordinateOperation, coordinateOperation2, coordinateOperation3});
    }

    private static boolean isIdentity(CoordinateOperation coordinateOperation) {
        return coordinateOperation instanceof Conversion && coordinateOperation.getMathTransform().isIdentity();
    }

    protected CoordinateOperation inverse(CoordinateOperation coordinateOperation) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getTargetCRS();
        Map<String, Object> map = AbstractIdentifiedObject.getProperties(coordinateOperation, null);
        map.putAll(AbstractCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem2, coordinateReferenceSystem));
        if (coordinateOperation instanceof ConcatenatedOperation) {
            LinkedList<CoordinateOperation> linkedList = new LinkedList<CoordinateOperation>();
            for (SingleOperation singleOperation : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                linkedList.addFirst(this.inverse(singleOperation));
            }
            return this.createConcatenatedOperation(map, linkedList.toArray(new CoordinateOperation[linkedList.size()]));
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform().inverse();
        Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
        OperationMethod operationMethod = coordinateOperation instanceof Operation ? ((Operation)coordinateOperation).getMethod() : null;
        return this.createFromMathTransform(map, coordinateReferenceSystem2, coordinateReferenceSystem, mathTransform, operationMethod, clazz);
    }

    static int getDimension(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem().getDimension() : 0;
    }

    private static String getClassName(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            Object object;
            Object object2 = identifiedObject.getClass();
            Class<?>[] classArray = ((Class)object2).getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                object = classArray[i];
                if (!((Class)object).getName().startsWith("org.opengis.referencing.")) continue;
                object2 = object;
                break;
            }
            String string = Classes.getShortName(object2);
            object = identifiedObject.getName();
            if (object != null) {
                string = string + '[' + object.getCode() + ']';
            }
            return string;
        }
        return null;
    }

    static Map<String, Object> getTemporaryName(IdentifiedObject identifiedObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", new TemporaryIdentifier(identifiedObject.getName()));
        hashMap.put("remarks", Vocabulary.formatInternational(45, AbstractCoordinateOperationFactory.getClassName(identifiedObject)));
        return hashMap;
    }

    static Map<String, ?> getTemporaryName(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        String string = AbstractCoordinateOperationFactory.getClassName(coordinateReferenceSystem) + " \u21e8 " + AbstractCoordinateOperationFactory.getClassName(coordinateReferenceSystem2);
        return Collections.singletonMap("name", string);
    }

    protected static String getErrorMessage(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        return Errors.format(140, AbstractCoordinateOperationFactory.getClassName(identifiedObject), AbstractCoordinateOperationFactory.getClassName(identifiedObject2));
    }

    protected static void ensureNonNull(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, string));
        }
    }

    private static final class TemporaryIdentifier
    extends NamedIdentifier {
        private static final long serialVersionUID = -2784354058026177076L;
        private final ReferenceIdentifier parent;
        private final int count;

        public TemporaryIdentifier(ReferenceIdentifier referenceIdentifier) {
            this(referenceIdentifier, (referenceIdentifier instanceof TemporaryIdentifier ? ((TemporaryIdentifier)referenceIdentifier).count : 0) + 1);
        }

        private TemporaryIdentifier(ReferenceIdentifier referenceIdentifier, int n) {
            super(Citations.GEOTOOLS, TemporaryIdentifier.unwrap(referenceIdentifier).getCode() + " (step " + n + ')');
            this.parent = referenceIdentifier;
            this.count = n;
        }

        public static ReferenceIdentifier unwrap(ReferenceIdentifier referenceIdentifier) {
            while (referenceIdentifier instanceof TemporaryIdentifier) {
                referenceIdentifier = ((TemporaryIdentifier)referenceIdentifier).parent;
            }
            return referenceIdentifier;
        }
    }
}

