/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.geotools.metadata.AbstractMetadata;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.PropertyAccessor;
import org.geotools.metadata.PropertyMap;
import org.geotools.resources.Classes;
import org.geotools.resources.OptionalDependencies;
import org.geotools.util.Utilities;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class PropertyTree {
    private static final int PRECISION = 12;
    private final MetadataStandard standard;
    private final Locale locale;
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;

    public PropertyTree(MetadataStandard metadataStandard) {
        this(metadataStandard, Locale.getDefault());
    }

    public PropertyTree(MetadataStandard metadataStandard, Locale locale) {
        this.standard = metadataStandard;
        this.locale = locale;
    }

    public MutableTreeNode asTree(Object object) {
        String string = Classes.getShortName(this.standard.getInterface(object.getClass()));
        DefaultMutableTreeNode defaultMutableTreeNode = OptionalDependencies.createTreeNode(this.localize(string), object, true);
        this.append(defaultMutableTreeNode, object);
        return defaultMutableTreeNode;
    }

    private void append(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2;
        if (object instanceof Map) {
            this.appendMap(defaultMutableTreeNode, (Map)object);
            return;
        }
        if (object instanceof AbstractMetadata) {
            this.appendMap(defaultMutableTreeNode, ((AbstractMetadata)object).asMap());
            return;
        }
        if (object != null && (object2 = this.standard.getAccessorOptional(object.getClass())) != null) {
            this.appendMap(defaultMutableTreeNode, new PropertyMap(object, (PropertyAccessor)object2));
            return;
        }
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (PropertyAccessor.isEmpty(e)) continue;
                this.append(defaultMutableTreeNode, e);
            }
            return;
        }
        object2 = object instanceof CodeList ? this.localize((CodeList)object) : (object instanceof Date ? this.format((Date)object) : (object instanceof Number ? this.format((Number)object) : (object instanceof InternationalString ? ((InternationalString)object).toString(this.locale) : String.valueOf(object))));
        defaultMutableTreeNode.add(OptionalDependencies.createTreeNode((String)object2, object, false));
    }

    private void appendMap(DefaultMutableTreeNode defaultMutableTreeNode, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            if (PropertyAccessor.isEmpty(v)) continue;
            String string = this.localize((String)entry.getKey());
            DefaultMutableTreeNode defaultMutableTreeNode2 = OptionalDependencies.createTreeNode(string, v, true);
            this.append(defaultMutableTreeNode2, v);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private String format(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.locale);
            this.numberFormat.setMinimumFractionDigits(0);
        }
        int n = 0;
        if (!Classes.isInteger(number.getClass())) {
            n = 12;
            double d = Math.abs(number.doubleValue());
            if (d > 0.0) {
                int n2 = (int)Math.log10(d);
                if (Math.abs(n2) >= 12) {
                    return number.toString();
                }
                if (n2 >= 0) {
                    n -= n2;
                }
                n = Math.max(0, 12 - n);
            }
        }
        this.numberFormat.setMaximumFractionDigits(n);
        return this.numberFormat.format(number);
    }

    private String format(Date date) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(1, 1, this.locale);
        }
        return this.dateFormat.format(date);
    }

    private String localize(String string) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            boolean bl = true;
            int n2 = 1;
            for (int i = 1; i < n; ++i) {
                boolean bl2 = Character.isUpperCase(string.charAt(i));
                if (bl2 != bl) {
                    int n3 = i;
                    if (bl) {
                        --n3;
                    }
                    if (n3 > n2) {
                        stringBuilder.append(string.substring(n2, n3)).append(' ');
                        n2 = n3;
                    }
                }
                bl = bl2;
            }
            String string2 = stringBuilder.append(string.substring(n2)).toString();
            if (!string2.equals(string)) {
                string = string2;
            }
        }
        return string;
    }

    private String localize(CodeList codeList) {
        return codeList.name().trim().replace('_', ' ').toLowerCase(this.locale);
    }

    public static String toString(TreeNode treeNode) {
        StringBuilder stringBuilder = new StringBuilder();
        PropertyTree.toString(treeNode, stringBuilder, 0, System.getProperty("line.separator", "\n"));
        return stringBuilder.toString();
    }

    private static void toString(TreeNode treeNode, StringBuilder stringBuilder, int n, String string) {
        TreeNode treeNode2;
        int n2 = treeNode.getChildCount();
        if (n2 == 0) {
            if (treeNode.isLeaf()) {
                stringBuilder.append(Utilities.spaces(n)).append(treeNode).append(string);
            }
            return;
        }
        stringBuilder.append(Utilities.spaces(n)).append(treeNode).append(':');
        if (n2 == 1 && (treeNode2 = treeNode.getChildAt(0)).isLeaf()) {
            stringBuilder.append(' ').append(treeNode2).append(string);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            TreeNode treeNode3 = treeNode.getChildAt(i);
            if (i == 0) {
                stringBuilder.append(string);
            }
            PropertyTree.toString(treeNode3, stringBuilder, n + 2, string);
        }
    }
}

