/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.StoreException;
import org.geotools.resources.NIOUtilities;

public class FileSystemNode
extends Node {
    static final int[] ZERO = new int[0];
    private ScrollingBuffer buffer;
    private int subNodeStartByte;
    private int subNodesLength;
    private int numSubNodes;

    FileSystemNode(Envelope envelope, ScrollingBuffer scrollingBuffer, int n, int n2) {
        super(envelope);
        this.buffer = scrollingBuffer;
        this.subNodeStartByte = n;
        this.subNodesLength = n2;
    }

    @Override
    public Node copy() throws IOException {
        FileSystemNode fileSystemNode = new FileSystemNode(this.getBounds(), this.buffer, this.subNodeStartByte, this.subNodesLength);
        fileSystemNode.numShapesId = this.numShapesId;
        fileSystemNode.shapesId = new int[this.numShapesId];
        System.arraycopy(this.shapesId, 0, fileSystemNode.shapesId, 0, this.numShapesId);
        fileSystemNode.numSubNodes = this.numSubNodes;
        return fileSystemNode;
    }

    @Override
    public int getNumSubNodes() {
        return this.numSubNodes;
    }

    public void setNumSubNodes(int n) {
        this.numSubNodes = n;
    }

    public int getSubNodeStartByte() {
        return this.subNodeStartByte;
    }

    public int getSubNodesLength() {
        return this.subNodesLength;
    }

    @Override
    public Node getSubNode(int n) throws StoreException {
        if (this.subNodes.size() > n) {
            return super.getSubNode(n);
        }
        try {
            FileSystemNode fileSystemNode = null;
            int n2 = this.subNodeStartByte;
            if (n > 0) {
                fileSystemNode = (FileSystemNode)this.getSubNode(n - 1);
                n2 = fileSystemNode.getSubNodeStartByte() + fileSystemNode.getSubNodesLength();
            }
            this.buffer.goTo(n2);
            int n3 = this.subNodes.size();
            for (int i = 0; i < n + 1 - n3; ++i) {
                fileSystemNode = FileSystemNode.readNode(n, this, this.buffer);
                this.addSubNode(fileSystemNode);
            }
        }
        catch (IOException iOException) {
            throw new StoreException(iOException);
        }
        return super.getSubNode(n);
    }

    public static FileSystemNode readNode(int n, Node node, FileChannel fileChannel, ByteOrder byteOrder, boolean bl) throws IOException {
        ScrollingBuffer scrollingBuffer = new ScrollingBuffer(fileChannel, byteOrder, bl);
        return FileSystemNode.readNode(n, node, scrollingBuffer);
    }

    static FileSystemNode readNode(int n, Node node, ScrollingBuffer scrollingBuffer) throws IOException {
        int n2 = scrollingBuffer.getInt();
        Envelope envelope = scrollingBuffer.getEnvelope();
        int n3 = scrollingBuffer.getInt();
        int[] nArray = null;
        if (n3 > 0) {
            nArray = new int[n3];
            scrollingBuffer.getIntArray(nArray);
        } else {
            nArray = ZERO;
        }
        int n4 = scrollingBuffer.getInt();
        FileSystemNode fileSystemNode = new FileSystemNode(envelope, scrollingBuffer, (int)scrollingBuffer.getPosition(), n2);
        fileSystemNode.setShapesId(nArray);
        fileSystemNode.setNumSubNodes(n4);
        return fileSystemNode;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        this.buffer = null;
    }

    private static class ScrollingBuffer {
        FileChannel channel;
        ByteOrder order;
        ByteBuffer buffer;
        long bufferStart;
        double[] envelope = new double[4];
        boolean useMemoryMapping;

        public ScrollingBuffer(FileChannel fileChannel, ByteOrder byteOrder, boolean bl) throws IOException {
            this.channel = fileChannel;
            this.order = byteOrder;
            this.useMemoryMapping = bl;
            this.bufferStart = fileChannel.position();
            if (bl) {
                this.buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, fileChannel.position(), fileChannel.size() - fileChannel.position());
                this.buffer.order(byteOrder);
            } else {
                this.buffer = NIOUtilities.allocate(8192);
                this.buffer.order(byteOrder);
                fileChannel.read(this.buffer);
                this.buffer.flip();
            }
        }

        public void close() {
            if (this.buffer != null) {
                NIOUtilities.clean(this.buffer, this.useMemoryMapping);
                this.buffer = null;
            }
        }

        public int getInt() throws IOException {
            if (!this.useMemoryMapping && this.buffer.remaining() < 4) {
                this.refillBuffer(4);
            }
            return this.buffer.getInt();
        }

        public Envelope getEnvelope() throws IOException {
            if (!this.useMemoryMapping && this.buffer.remaining() < 32) {
                this.refillBuffer(32);
            }
            this.buffer.asDoubleBuffer().get(this.envelope);
            this.buffer.position(this.buffer.position() + 32);
            return new Envelope(this.envelope[0], this.envelope[2], this.envelope[1], this.envelope[3]);
        }

        public void getIntArray(int[] nArray) throws IOException {
            int n = nArray.length * 4;
            if (this.buffer.remaining() < n) {
                this.refillBuffer(n);
            }
            IntBuffer intBuffer = this.buffer.asIntBuffer();
            intBuffer.limit(nArray.length);
            intBuffer.get(nArray);
            this.buffer.position(this.buffer.position() + n);
        }

        void refillBuffer(int n) throws IOException {
            long l = this.bufferStart + (long)this.buffer.position();
            if (this.buffer.capacity() < n) {
                int n2;
                for (n2 = this.buffer.capacity(); n2 < n; n2 *= 2) {
                }
                this.buffer = NIOUtilities.allocate(n2);
                this.buffer.order(this.order);
            }
            this.readBuffer(l);
        }

        private void readBuffer(long l) throws IOException {
            this.channel.position(l);
            this.buffer.clear();
            this.channel.read(this.buffer);
            this.buffer.flip();
            this.bufferStart = l;
        }

        public void goTo(long l) throws IOException {
            if (this.useMemoryMapping || l >= this.bufferStart && l <= this.bufferStart + (long)this.buffer.limit()) {
                this.buffer.position((int)(l - this.bufferStart));
            } else {
                this.readBuffer(l);
            }
        }

        public long getPosition() {
            return this.bufferStart + (long)this.buffer.position();
        }
    }
}

