/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index;

import java.nio.charset.Charset;
import java.util.ArrayList;

public class DataDefinition {
    private Charset charset;
    private ArrayList<Field> fields = new ArrayList();

    public DataDefinition(String string) {
        this.charset = Charset.forName(string);
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public Field getField(int n) {
        return this.fields.get(n);
    }

    public void addField(Class clazz) {
        if (clazz.isAssignableFrom(Short.class)) {
            this.fields.add(new Field(clazz, 2));
        } else if (clazz.isAssignableFrom(Integer.class)) {
            this.fields.add(new Field(clazz, 4));
        } else if (clazz.isAssignableFrom(Long.class)) {
            this.fields.add(new Field(clazz, 8));
        } else if (clazz.isAssignableFrom(Float.class)) {
            this.fields.add(new Field(clazz, 4));
        } else if (clazz.isAssignableFrom(Double.class)) {
            this.fields.add(new Field(clazz, 8));
        } else {
            throw new IllegalArgumentException("Unknow len of class " + clazz + "use addField(int)");
        }
    }

    public int getLen() {
        int n = 0;
        Field field = null;
        for (int i = 0; i < this.fields.size(); ++i) {
            field = this.fields.get(i);
            n += field.getLen();
        }
        return n;
    }

    public int getEncodedLen() {
        int n = 0;
        Field field = null;
        for (int i = 0; i < this.fields.size(); ++i) {
            field = this.fields.get(i);
            n += field.getEncodedLen();
        }
        return n;
    }

    public class Field {
        private Class clazz;
        private int len;

        public Field(Class clazz, int n) {
            this.clazz = clazz;
            this.len = n;
        }

        public Class getFieldClass() {
            return this.clazz;
        }

        public int getLen() {
            return this.len;
        }

        public int getEncodedLen() {
            int n = this.len;
            if (this.clazz.equals(String.class)) {
                n = (int)DataDefinition.this.charset.newEncoder().maxBytesPerChar() * this.len;
            }
            return n;
        }
    }
}

