/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.List;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.util.Utilities;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class FeatureTypeImpl
extends ComplexTypeImpl
implements FeatureType {
    private GeometryDescriptor defaultGeometry;
    private CoordinateReferenceSystem crs;

    public FeatureTypeImpl(Name name, Collection<PropertyDescriptor> collection, GeometryDescriptor geometryDescriptor, boolean bl, List<Filter> list, AttributeType attributeType, InternationalString internationalString) {
        super(name, collection, true, bl, list, attributeType, internationalString);
        this.defaultGeometry = geometryDescriptor;
        if (geometryDescriptor != null && geometryDescriptor.getType() == null) {
            throw new IllegalArgumentException("defaultGeometry must have a GeometryType");
        }
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.crs == null) {
            if (this.getGeometryDescriptor() != null && this.getGeometryDescriptor().getType().getCoordinateReferenceSystem() != null) {
                this.crs = this.defaultGeometry.getType().getCoordinateReferenceSystem();
            }
            if (this.crs == null) {
                for (PropertyDescriptor propertyDescriptor : this.getDescriptors()) {
                    GeometryDescriptor geometryDescriptor;
                    if (!(propertyDescriptor instanceof GeometryDescriptor) || (geometryDescriptor = (GeometryDescriptor)propertyDescriptor).getType().getCoordinateReferenceSystem() == null) continue;
                    this.crs = geometryDescriptor.getType().getCoordinateReferenceSystem();
                    break;
                }
            }
        }
        return this.crs;
    }

    @Override
    public GeometryDescriptor getGeometryDescriptor() {
        if (this.defaultGeometry == null) {
            for (PropertyDescriptor propertyDescriptor : this.getDescriptors()) {
                if (!(propertyDescriptor instanceof GeometryDescriptor)) continue;
                this.defaultGeometry = (GeometryDescriptor)propertyDescriptor;
                break;
            }
        }
        return this.defaultGeometry;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FeatureType featureType = (FeatureType)object;
        return Utilities.equals(this.getGeometryDescriptor(), featureType.getGeometryDescriptor());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        if (this.defaultGeometry != null) {
            n ^= this.defaultGeometry.hashCode();
        }
        return n;
    }
}

