/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.opengis.feature.simple.SimpleFeatureType;

public class ShapeFIDReader
implements FIDReader {
    protected static final String CLOSE_MESG = "Close has already been called on this FIDReader";
    private boolean opened;
    private ShapefileAttributeReader reader;
    private int len;
    protected StringBuffer buffer;

    public ShapeFIDReader(String string, ShapefileAttributeReader shapefileAttributeReader) {
        this.buffer = new StringBuffer(string);
        this.buffer.append('.');
        this.len = string.length() + 1;
        this.opened = true;
        this.reader = shapefileAttributeReader;
    }

    public ShapeFIDReader(SimpleFeatureType simpleFeatureType, ShapefileAttributeReader shapefileAttributeReader) {
        this(simpleFeatureType.getTypeName(), shapefileAttributeReader);
    }

    @Override
    public void close() {
        this.opened = false;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (!this.opened) {
            throw new IOException(CLOSE_MESG);
        }
        return true;
    }

    @Override
    public String next() throws IOException {
        if (!this.opened) {
            throw new IOException(CLOSE_MESG);
        }
        this.buffer.delete(this.len, this.buffer.length());
        this.buffer.append(this.reader.getRecordNumber());
        return this.buffer.toString();
    }
}

