/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public abstract class AbstractFeatureLocking
extends AbstractFeatureStore
implements SimpleFeatureLocking {
    FeatureLock featureLock = FeatureLock.TRANSACTION;

    public AbstractFeatureLocking() {
    }

    public AbstractFeatureLocking(Set set) {
        super(set);
    }

    @Override
    public void setFeatureLock(FeatureLock featureLock) {
        if (featureLock == null) {
            throw new NullPointerException("A FeatureLock is required - did you mean FeatureLock.TRANSACTION?");
        }
        this.featureLock = featureLock;
    }

    @Override
    public int lockFeatures() throws IOException {
        return this.lockFeatures(Filter.INCLUDE);
    }

    @Override
    public int lockFeatures(Filter filter) throws IOException {
        return this.lockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int lockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        SimpleFeatureIterator simpleFeatureIterator = this.getFeatures(query).features();
        String string = query.getTypeName();
        int n = 0;
        try {
            while (simpleFeatureIterator.hasNext()) {
                try {
                    SimpleFeature simpleFeature = (SimpleFeature)simpleFeatureIterator.next();
                    lockingManager.lockFeatureID(string, simpleFeature.getID(), this.getTransaction(), this.featureLock);
                    ++n;
                }
                catch (FeatureLockException featureLockException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", noSuchElementException);
                    return n;
                }
            }
        }
        finally {
            simpleFeatureIterator.close();
        }
    }

    @Override
    public void unLockFeatures() throws IOException {
        this.unLockFeatures(Filter.INCLUDE);
    }

    @Override
    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unLockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        SimpleFeatureIterator simpleFeatureIterator = this.getFeatures(query).features();
        String string = query.getTypeName();
        try {
            while (simpleFeatureIterator.hasNext()) {
                try {
                    SimpleFeature simpleFeature = (SimpleFeature)simpleFeatureIterator.next();
                    lockingManager.unLockFeatureID(string, simpleFeature.getID(), this.getTransaction(), this.featureLock);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", noSuchElementException);
                    return;
                }
            }
        }
        finally {
            simpleFeatureIterator.close();
        }
    }
}

