/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WikipediaToggleDialog
extends ToggleDialog {
    final StringProperty wikipediaLang = new StringProperty("wikipedia.lang", LanguageInfo.getJOSMLocaleCode().substring(0, 2));
    final DefaultListModel<WikipediaEntry> model = new DefaultListModel();
    final JList<WikipediaEntry> list = new JList<WikipediaEntry>(this.model){
        {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.getSelectedValue() != null) {
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        bbox.visit(((WikipediaEntry)this.getSelectedValue()).coordinate);
                        Main.map.mapView.recalculateCenterScale(bbox);
                    }
                }
            });
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            int index = this.locationToIndex(e.getPoint());
            if (index >= 0) {
                return "<html>" + WikipediaToggleDialog.this.model.getElementAt((int)index).description + "</html>";
            }
            return null;
        }
    };

    public WikipediaToggleDialog() {
        super(I18n.tr((String)"Wikipedia", (Object[])new Object[0]), "wikipedia", I18n.tr((String)"Fetch Wikipedia articles with coordinates", (Object[])new Object[0]), null, 150);
        this.createLayout(this.list, true, Arrays.asList(new SideButton((Action)new WikipediaDownloadAction()), new SideButton((Action)new AddWikipediaTagAction()), new SideButton((Action)new OpenWikipediaArticleAction()), new SideButton((Action)new WikipediaSettingsAction(), false)));
    }

    class AddWikipediaTagAction
    extends AbstractAction {
        public AddWikipediaTagAction() {
            super(I18n.tr((String)"Add Tag", (Object[])new Object[0]), ImageProvider.get((String)"pastetags"));
            this.putValue("ShortDescription", I18n.tr((String)"Adds a ''wikipedia'' tag corresponding to this article to the selected objects", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tag tag;
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null && (tag = WikipediaToggleDialog.this.list.getSelectedValue().createWikipediaTag()) != null) {
                ChangePropertyCommand cmd = new ChangePropertyCommand(Main.main.getCurrentDataSet().getSelected(), tag.getKey(), tag.getValue());
                Main.main.undoRedo.add((Command)cmd);
            }
        }
    }

    class WikipediaSettingsAction
    extends AbstractAction {
        public WikipediaSettingsAction() {
            super(I18n.tr((String)"Language", (Object[])new Object[0]), ImageProvider.get((String)"dialogs/settings"));
            this.putValue("ShortDescription", I18n.tr((String)"Sets the default language for the Wikipedia articles", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lang = JOptionPane.showInputDialog((Component)((Object)WikipediaToggleDialog.this), I18n.tr((String)"Enter the Wikipedia language", (Object[])new Object[0]), WikipediaToggleDialog.this.wikipediaLang.get());
            if (lang != null) {
                WikipediaToggleDialog.this.wikipediaLang.put(lang);
            }
        }
    }

    class OpenWikipediaArticleAction
    extends AbstractAction {
        public OpenWikipediaArticleAction() {
            super(I18n.tr((String)"Open Article", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Opens the Wikipedia article of the selected item in a browser", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url;
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null && (url = WikipediaToggleDialog.this.list.getSelectedValue().getHrefFromDescription()) != null) {
                System.out.println("Wikipedia: opening " + url);
                OpenBrowser.displayUrl((String)url);
            }
        }
    }

    class WikipediaDownloadAction
    extends AbstractAction {
        public WikipediaDownloadAction() {
            super(I18n.tr((String)"Reload", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"refresh"));
            this.putValue("ShortDescription", I18n.tr((String)"Fetches all coordinates from Wikipedia in the current view", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LatLon min = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
                LatLon max = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
                String bbox = min.lon() + "," + min.lat() + "," + max.lon() + "," + max.lat();
                String url = "http://toolserver.org/~kolossos/geoworld/marks.php?bbox=" + bbox + "&LANG=" + WikipediaToggleDialog.this.wikipediaLang.get();
                System.out.println("Wikipedia: GET " + url);
                XPathExpression xpathPlacemark = XPathFactory.newInstance().newXPath().compile("//Placemark");
                XPathExpression xpathName = XPathFactory.newInstance().newXPath().compile("name/text()");
                XPathExpression xpathCoord = XPathFactory.newInstance().newXPath().compile("Point/coordinates/text()");
                XPathExpression xpathDescr = XPathFactory.newInstance().newXPath().compile("description");
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL(url).openStream());
                NodeList nodes = (NodeList)xpathPlacemark.evaluate(doc, XPathConstants.NODESET);
                LinkedList<WikipediaEntry> entries = new LinkedList<WikipediaEntry>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] coord = xpathCoord.evaluate(nodes.item(i)).split(",");
                    if (coord.length <= 2) continue;
                    String name = xpathName.evaluate(nodes.item(i));
                    String descr = xpathDescr.evaluate(nodes.item(i));
                    entries.add(new WikipediaEntry(name, descr, new LatLon(Double.parseDouble(coord[1]), Double.parseDouble(coord[0]))));
                }
                Collections.sort(entries);
                WikipediaToggleDialog.this.model.clear();
                for (WikipediaEntry i : entries) {
                    WikipediaToggleDialog.this.model.addElement(i);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static class WikipediaEntry
    implements Comparable<WikipediaEntry> {
        String name;
        String description;
        LatLon coordinate;

        public WikipediaEntry(String name, String description, LatLon coordinate) {
            this.name = name;
            this.description = description;
            this.coordinate = coordinate;
        }

        public String getHrefFromDescription() {
            Matcher m = Pattern.compile(".*href=\"(.+?)\".*").matcher(this.description);
            if (m.matches()) {
                return m.group(1);
            }
            System.err.println("Could not parse URL from: " + this.description);
            return null;
        }

        public Tag createWikipediaTag() {
            String url = this.getHrefFromDescription();
            if (url == null) {
                return null;
            }
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
            Matcher m = Pattern.compile("https?://(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
            if (!m.matches()) {
                System.err.println("Could not extract Wikipedia tag from: " + url);
                return null;
            }
            return new Tag("wikipedia", m.group(1) + ":" + m.group(2));
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WikipediaEntry o) {
            return this.name.compareTo(o.name);
        }
    }
}

