/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jts.precision.PrecisionReducerCoordinateOperation;

public class GeometryPrecisionReducer {
    private PrecisionModel targetPM;
    private boolean removeCollapsed = true;
    private boolean changePrecisionModel = false;
    private boolean isPointwise = false;

    public static Geometry reduce(Geometry g, PrecisionModel precModel) {
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precModel);
        return reducer.reduce(g);
    }

    public static Geometry reducePointwise(Geometry g, PrecisionModel precModel) {
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precModel);
        reducer.setPointwise(true);
        return reducer.reduce(g);
    }

    public GeometryPrecisionReducer(PrecisionModel pm) {
        this.targetPM = pm;
    }

    public void setRemoveCollapsedComponents(boolean removeCollapsed) {
        this.removeCollapsed = removeCollapsed;
    }

    public void setChangePrecisionModel(boolean changePrecisionModel) {
        this.changePrecisionModel = changePrecisionModel;
    }

    public void setPointwise(boolean isPointwise) {
        this.isPointwise = isPointwise;
    }

    public Geometry reduce(Geometry geom) {
        Geometry reducePW = this.reducePointwise(geom);
        if (this.isPointwise) {
            return reducePW;
        }
        if (!(reducePW instanceof Polygonal)) {
            return reducePW;
        }
        if (reducePW.isValid()) {
            return reducePW;
        }
        return this.fixPolygonalTopology(reducePW);
    }

    private Geometry reducePointwise(Geometry geom) {
        GeometryEditor geomEdit;
        if (this.changePrecisionModel) {
            GeometryFactory newFactory = this.createFactory(geom.getFactory(), this.targetPM);
            geomEdit = new GeometryEditor(newFactory);
        } else {
            geomEdit = new GeometryEditor();
        }
        boolean finalRemoveCollapsed = this.removeCollapsed;
        if (geom.getDimension() >= 2) {
            finalRemoveCollapsed = true;
        }
        Geometry reduceGeom = geomEdit.edit(geom, new PrecisionReducerCoordinateOperation(this.targetPM, finalRemoveCollapsed));
        return reduceGeom;
    }

    private Geometry fixPolygonalTopology(Geometry geom) {
        Geometry bufGeom;
        Geometry geomToBuffer = geom;
        if (!this.changePrecisionModel) {
            geomToBuffer = this.changePM(geom, this.targetPM);
        }
        Geometry finalGeom = bufGeom = geomToBuffer.buffer(0.0);
        if (!this.changePrecisionModel) {
            PrecisionModel originalPM = geom.getFactory().getPrecisionModel();
            finalGeom = this.changePM(bufGeom, originalPM);
        }
        return finalGeom;
    }

    private Geometry changePM(Geometry geom, PrecisionModel pm) {
        GeometryEditor geomEditor = this.createEditor(geom.getFactory(), pm);
        return geomEditor.edit(geom, new GeometryEditor.NoOpGeometryOperation());
    }

    private GeometryEditor createEditor(GeometryFactory geomFactory, PrecisionModel pm) {
        if (geomFactory.getPrecisionModel() == pm) {
            return new GeometryEditor();
        }
        GeometryFactory newFactory = this.createFactory(geomFactory, this.targetPM);
        GeometryEditor geomEdit = new GeometryEditor(newFactory);
        return geomEdit;
    }

    private GeometryFactory createFactory(GeometryFactory inputFactory, PrecisionModel pm) {
        GeometryFactory newFactory = new GeometryFactory(pm, inputFactory.getSRID(), inputFactory.getCoordinateSequenceFactory());
        return newFactory;
    }
}

