/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        double dx1 = p2.x - p1.x;
        double dy1 = p2.y - p1.y;
        double dx2 = q.x - p2.x;
        double dy2 = q.y - p2.y;
        return RobustDeterminant.signOfDet2x2(dx1, dy1, dx2, dy2);
    }

    public static boolean isPointInRing(Coordinate p, Coordinate[] ring) {
        return CGAlgorithms.locatePointInRing(p, ring) != 2;
    }

    public static int locatePointInRing(Coordinate p, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p, ring);
    }

    public static boolean isOnLine(Coordinate p, Coordinate[] pt) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        for (int i = 1; i < pt.length; ++i) {
            Coordinate p0 = pt[i - 1];
            Coordinate p1 = pt[i];
            ((LineIntersector)lineIntersector).computeIntersection(p, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 3 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        for (int i = 1; i <= nPts; ++i) {
            Coordinate p = ring[i];
            if (!(p.y > hiPt.y)) continue;
            hiPt = p;
            hiIndex = i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = CGAlgorithms.computeOrientation(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x > next.x : disc > 0;
        return isCCW;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithms.orientationIndex(p1, p2, q);
    }

    public static double distancePointLine(Coordinate p, Coordinate A, Coordinate B) {
        if (A.x == B.x && A.y == B.y) {
            return p.distance(A);
        }
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        if (r <= 0.0) {
            return p.distance(A);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        return Math.abs(s) * Math.sqrt((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
    }

    public static double distancePointLinePerpendicular(Coordinate p, Coordinate A, Coordinate B) {
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        return Math.abs(s) * Math.sqrt((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
    }

    public static double distancePointLine(Coordinate p, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        for (int i = 0; i < line.length - 1; ++i) {
            double dist = CGAlgorithms.distancePointLine(p, line[i], line[i + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double distanceLineLine(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        if (A.equals(B)) {
            return CGAlgorithms.distancePointLine(A, C, D);
        }
        if (C.equals(D)) {
            return CGAlgorithms.distancePointLine(D, A, B);
        }
        double r_top = (A.y - C.y) * (D.x - C.x) - (A.x - C.x) * (D.y - C.y);
        double r_bot = (B.x - A.x) * (D.y - C.y) - (B.y - A.y) * (D.x - C.x);
        double s_top = (A.y - C.y) * (B.x - A.x) - (A.x - C.x) * (B.y - A.y);
        double s_bot = (B.x - A.x) * (D.y - C.y) - (B.y - A.y) * (D.x - C.x);
        if (r_bot == 0.0 || s_bot == 0.0) {
            return Math.min(CGAlgorithms.distancePointLine(A, C, D), Math.min(CGAlgorithms.distancePointLine(B, C, D), Math.min(CGAlgorithms.distancePointLine(C, A, B), CGAlgorithms.distancePointLine(D, A, B))));
        }
        double s = s_top / s_bot;
        double r = r_top / r_bot;
        if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
            return Math.min(CGAlgorithms.distancePointLine(A, C, D), Math.min(CGAlgorithms.distancePointLine(B, C, D), Math.min(CGAlgorithms.distancePointLine(C, A, B), CGAlgorithms.distancePointLine(D, A, B))));
        }
        return 0.0;
    }

    public static double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < ring.length - 1; ++i) {
            double bx = ring[i].x;
            double by = ring[i].y;
            double cx = ring[i + 1].x;
            double cy = ring[i + 1].y;
            sum += (bx + cx) * (cy - by);
        }
        return -sum / 2.0;
    }

    public static double signedArea(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        double sum = 0.0;
        Coordinate p = new Coordinate();
        ring.getCoordinate(0, p);
        double bx = p.x;
        double by = p.y;
        for (int i = 1; i < n; ++i) {
            ring.getCoordinate(i, p);
            double cx = p.x;
            double cy = p.y;
            sum += (bx + cx) * (cy - by);
            bx = cx;
            by = cy;
        }
        return -sum / 2.0;
    }

    public static double length(CoordinateSequence pts) {
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = new Coordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x;
        double y0 = p.y;
        for (int i = 1; i < n; ++i) {
            pts.getCoordinate(i, p);
            double x1 = p.x;
            double y1 = p.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }
}

