/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;

public final class JTSUtils {
    public final OsmPrecisionModel osmPrecisionModel = new OsmPrecisionModel();
    public final GeometryFactory osmGeometryFactory = new GeometryFactory(this.getPrecisionModel());

    public OsmPrecisionModel getPrecisionModel() {
        return this.osmPrecisionModel;
    }

    public GeometryFactory getGeometryFactory() {
        return this.osmGeometryFactory;
    }

    public Coordinate convertNodeToCoordinate(Node node) {
        LatLon ll = node.getCoor();
        return new Coordinate(ll.lon(), ll.lat());
    }

    public CoordinateSequence convertNodesToCoordinateSequence(List<Node> nodes) {
        Coordinate[] coords = new Coordinate[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            coords[i] = this.convertNodeToCoordinate(nodes.get(i));
        }
        return new CoordinateArraySequence(coords);
    }

    public Point convertNode(Node node) {
        Coordinate[] coords = new Coordinate[]{this.convertNodeToCoordinate(node)};
        return new Point(new CoordinateArraySequence(coords), this.getGeometryFactory());
    }

    public Geometry convertWay(Way way) {
        CoordinateSequence coordSeq = this.convertNodesToCoordinateSequence(way.getNodes());
        if (way.isClosed()) {
            LinearRing ring = new LinearRing(coordSeq, this.getGeometryFactory());
            return new Polygon(ring, null, this.getGeometryFactory());
        }
        return new LineString(coordSeq, this.getGeometryFactory());
    }

    public Geometry convert(OsmPrimitive prim) {
        if (prim instanceof Node) {
            return this.convertNode((Node)prim);
        }
        if (prim instanceof Way) {
            return this.convertWay((Way)prim);
        }
        if (prim instanceof Relation) {
            throw new UnsupportedOperationException("Relations not supported yet.");
        }
        throw new UnsupportedOperationException("Unknown primitive.");
    }

    public class OsmPrecisionModel
    extends PrecisionModel {
        public OsmPrecisionModel() {
            super(1.0E7);
        }
    }
}

