/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import org.geotools.metadata.iso.extent.GeographicExtentImpl;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.GeographicBoundingBox;

public class GeographicBoundingBoxImpl
extends GeographicExtentImpl
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    private static Method toString;
    public static final GeographicBoundingBox WORLD;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public GeographicBoundingBoxImpl() {
    }

    public GeographicBoundingBoxImpl(GeographicBoundingBox box) {
        this.setBounds(box);
    }

    public GeographicBoundingBoxImpl(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        super(true);
        this.setBounds(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
    }

    @Override
    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    @Override
    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    @Override
    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    @Override
    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public synchronized void setBounds(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        this.checkWritePermission();
        this.westBoundLongitude = westBoundLongitude;
        this.eastBoundLongitude = eastBoundLongitude;
        this.southBoundLatitude = southBoundLatitude;
        this.northBoundLatitude = northBoundLatitude;
    }

    public void setBounds(GeographicBoundingBox box) {
        GeographicBoundingBoxImpl.ensureNonNull("box", box);
        this.setInclusion(box.getInclusion());
        this.setBounds(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude());
    }

    public synchronized void add(GeographicBoundingBox box) {
        this.checkWritePermission();
        double xmin = box.getWestBoundLongitude();
        double xmax = box.getEastBoundLongitude();
        double ymin = box.getSouthBoundLatitude();
        double ymax = box.getNorthBoundLatitude();
        Boolean inc1 = this.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", inc1);
        Boolean inc2 = box.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", inc2);
        if (inc1.booleanValue() == inc2.booleanValue()) {
            if (xmin < this.westBoundLongitude) {
                this.westBoundLongitude = xmin;
            }
            if (xmax > this.eastBoundLongitude) {
                this.eastBoundLongitude = xmax;
            }
            if (ymin < this.southBoundLatitude) {
                this.southBoundLatitude = ymin;
            }
            if (ymax > this.northBoundLatitude) {
                this.northBoundLatitude = ymax;
            }
        } else {
            if (ymin <= this.southBoundLatitude && ymax >= this.northBoundLatitude) {
                if (xmin > this.westBoundLongitude) {
                    this.westBoundLongitude = xmin;
                }
                if (xmax < this.eastBoundLongitude) {
                    this.eastBoundLongitude = xmax;
                }
            }
            if (xmin <= this.westBoundLongitude && xmax >= this.eastBoundLongitude) {
                if (ymin > this.southBoundLatitude) {
                    this.southBoundLatitude = ymin;
                }
                if (ymax < this.northBoundLatitude) {
                    this.northBoundLatitude = ymax;
                }
            }
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(GeographicBoundingBoxImpl.class)) {
            GeographicBoundingBoxImpl that = (GeographicBoundingBoxImpl)object;
            return Utilities.equals(this.getInclusion(), that.getInclusion()) && Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(that.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(that.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(that.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(that.westBoundLongitude);
        }
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        if (!this.getClass().equals(GeographicBoundingBoxImpl.class)) {
            return super.hashCode();
        }
        Boolean inclusion = this.getInclusion();
        int code = inclusion != null ? inclusion.hashCode() : 0;
        code += GeographicBoundingBoxImpl.hashCode(this.southBoundLatitude);
        code += GeographicBoundingBoxImpl.hashCode(this.northBoundLatitude);
        code += GeographicBoundingBoxImpl.hashCode(this.eastBoundLongitude);
        return code += GeographicBoundingBoxImpl.hashCode(this.westBoundLongitude);
    }

    private static int hashCode(double value) {
        long code = Double.doubleToLongBits(value);
        return (int)code ^ (int)(code >>> 32);
    }

    @Override
    public String toString() {
        return GeographicBoundingBoxImpl.toString(this, "DD\u00c2\u00b0MM'SS.s\"", null);
    }

    public static String toString(GeographicBoundingBox box, String pattern, Locale locale) {
        if (toString == null) {
            toString = GeographicBoundingBoxImpl.getMethod("toString", new Class[]{GeographicBoundingBox.class, String.class, Locale.class});
        }
        try {
            return String.valueOf(GeographicBoundingBoxImpl.invoke(toString, new Object[]{box, pattern, locale}));
        }
        catch (InvocationTargetException exception) {
            throw new UndeclaredThrowableException(exception.getTargetException());
        }
    }

    private static Method getMethod(String name, Class<?>[] arguments) {
        try {
            return Class.forName("org.geotools.resources.BoundingBoxes").getMethod(name, arguments);
        }
        catch (ClassNotFoundException exception) {
            throw new UnsupportedOperationException(Errors.format(98, "referencing"), exception);
        }
        catch (NoSuchMethodException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static Object invoke(Method method, Object[] arguments) throws InvocationTargetException {
        try {
            return method.invoke(null, arguments);
        }
        catch (IllegalAccessException exception) {
            throw new AssertionError((Object)exception);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw exception;
        }
    }

    static {
        GeographicBoundingBoxImpl world = new GeographicBoundingBoxImpl(-180.0, 180.0, -90.0, 90.0);
        world.freeze();
        WORLD = world;
    }
}

