/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.rmi.server.UID;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class SimpleFeatureBuilder {
    SimpleFeatureType featureType;
    FeatureFactory factory;
    Map<String, Integer> index;
    Object[] values;
    int next;
    Map<Object, Object>[] userData;
    Map<Object, Object> featureUserData;
    boolean validating;

    public SimpleFeatureBuilder(SimpleFeatureType featureType) {
        this(featureType, CommonFactoryFinder.getFeatureFactory(null));
    }

    public SimpleFeatureBuilder(SimpleFeatureType featureType, FeatureFactory factory) {
        this.featureType = featureType;
        this.factory = factory;
        this.index = featureType instanceof SimpleFeatureTypeImpl ? ((SimpleFeatureTypeImpl)featureType).index : SimpleFeatureTypeImpl.buildIndex(featureType);
        this.reset();
    }

    public void reset() {
        this.values = new Object[this.featureType.getAttributeCount()];
        this.next = 0;
        this.userData = null;
        this.featureUserData = null;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void init(SimpleFeature feature) {
        this.reset();
        if (feature instanceof SimpleFeatureImpl) {
            SimpleFeatureImpl impl = (SimpleFeatureImpl)feature;
            System.arraycopy(impl.values, 0, this.values, 0, impl.values.length);
        } else {
            for (Object value : feature.getAttributes()) {
                this.add(value);
            }
        }
    }

    public void add(Object value) {
        this.set(this.next, value);
        ++this.next;
    }

    public void addAll(List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.add(values.get(i));
        }
    }

    public void addAll(Object[] values) {
        this.addAll(Arrays.asList(values));
    }

    public void set(Name name, Object value) {
        this.set(name.getLocalPart(), value);
    }

    public void set(String name, Object value) {
        int index = this.featureType.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("No such attribute:" + name);
        }
        this.set(index, value);
    }

    public void set(int index, Object value) {
        if (index >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Can handle " + this.values.length + " attributes only, index is " + index);
        }
        AttributeDescriptor descriptor = this.featureType.getDescriptor(index);
        this.values[index] = this.convert(value, descriptor);
        if (this.validating) {
            Types.validate(descriptor, this.values[index]);
        }
    }

    private Object convert(Object value, AttributeDescriptor descriptor) {
        if (value != null) {
            Class<?> target = descriptor.getType().getBinding();
            Object converted = Converters.convert(value, target);
            if (converted != null) {
                value = converted;
            }
        } else if (!descriptor.isNillable() && (value = descriptor.getDefaultValue()) == null) {
            value = DataUtilities.defaultValue(descriptor.getType().getBinding());
        }
        return value;
    }

    public SimpleFeature buildFeature(String id) {
        if (id == null) {
            id = SimpleFeatureBuilder.createDefaultFeatureId();
        }
        Object[] values = this.values;
        Map<Object, Object>[] userData = this.userData;
        Map<Object, Object> featureUserData = this.featureUserData;
        this.reset();
        SimpleFeature sf = this.factory.createSimpleFeature(values, this.featureType, id);
        if (userData != null) {
            for (int i = 0; i < userData.length; ++i) {
                if (userData[i] == null) continue;
                sf.getProperty(this.featureType.getDescriptor(i).getName()).getUserData().putAll(userData[i]);
            }
        }
        if (featureUserData != null) {
            sf.getUserData().putAll(featureUserData);
        }
        return sf;
    }

    public static String createDefaultFeatureId() {
        return "fid-" + new UID().toString().replace(':', '_');
    }

    public static SimpleFeature build(SimpleFeatureType type, Object[] values, String id) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.addAll(values);
        return builder.buildFeature(id);
    }

    public static SimpleFeature build(SimpleFeatureType type, List<Object> values, String id) {
        return SimpleFeatureBuilder.build(type, values.toArray(), id);
    }

    public static SimpleFeature copy(SimpleFeature original) {
        if (original == null) {
            return null;
        }
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(original.getFeatureType());
        builder.init(original);
        return builder.buildFeature(original.getID());
    }
}

