/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReTypingIterator
implements Iterator {
    Iterator delegate;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;

    public ReTypingIterator(Iterator delegate, SimpleFeatureType source, SimpleFeatureType target) {
        this.delegate = delegate;
        this.types = this.typeAttributes(source, target);
        this.builder = new SimpleFeatureBuilder(target);
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        SimpleFeature next = (SimpleFeature)this.delegate.next();
        String id = next.getID();
        try {
            for (int i = 0; i < this.types.length; ++i) {
                String xpath = this.types[i].getLocalName();
                this.builder.add(next.getAttribute(xpath));
            }
            return this.builder.buildFeature(id);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException(e);
        }
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType original, SimpleFeatureType target) {
        if (target.equals(original)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > original.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] types = new AttributeDescriptor[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attrib = target.getDescriptor(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            if (attrib.equals(original.getDescriptor(xpath))) continue;
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover " + xpath + ")");
        }
        return types;
    }
}

