/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class IsSimpleOp {
    private Geometry geom;
    private boolean isClosedEndpointsInInterior = true;

    public IsSimpleOp(Geometry geometry) {
        this.geom = geometry;
    }

    public boolean isSimple() {
        if (this.geom instanceof LineString) {
            return this.isSimpleLinearGeometry(this.geom);
        }
        if (this.geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(this.geom);
        }
        if (this.geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)this.geom);
        }
        return true;
    }

    private boolean isSimpleMultiPoint(MultiPoint multiPoint) {
        if (multiPoint.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            Point point = (Point)multiPoint.getGeometryN(i);
            Coordinate coordinate = point.getCoordinate();
            if (treeSet.contains(coordinate)) {
                return false;
            }
            treeSet.add(coordinate);
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry geometry) {
        if (geometry.isEmpty()) {
            return true;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, geometry);
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        SegmentIntersector segmentIntersector = geometryGraph.computeSelfNodes(robustLineIntersector, true);
        if (!segmentIntersector.hasIntersection()) {
            return true;
        }
        if (segmentIntersector.hasProperIntersection()) {
            return false;
        }
        if (this.hasNonEndpointIntersection(geometryGraph)) {
            return false;
        }
        return !this.isClosedEndpointsInInterior || !this.hasClosedEndpointIntersection(geometryGraph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph geometryGraph) {
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            int n = edge.getMaximumSegmentIndex();
            Iterator iterator2 = edge.getEdgeIntersectionList().iterator();
            while (iterator2.hasNext()) {
                EdgeIntersection edgeIntersection = (EdgeIntersection)iterator2.next();
                if (edgeIntersection.isEndPoint(n)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph geometryGraph) {
        TreeMap treeMap = new TreeMap();
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            Object object = (Edge)iterator.next();
            boolean bl = ((Edge)object).isClosed();
            Coordinate coordinate = ((Edge)object).getCoordinate(0);
            this.addEndpoint(treeMap, coordinate, bl);
            Coordinate coordinate2 = ((Edge)object).getCoordinate(((Edge)object).getNumPoints() - 1);
            this.addEndpoint(treeMap, coordinate2, bl);
        }
        for (Object object : treeMap.values()) {
            if (!((EndpointInfo)object).isClosed || ((EndpointInfo)object).degree == 2) continue;
            return true;
        }
        return false;
    }

    private void addEndpoint(Map map, Coordinate coordinate, boolean bl) {
        EndpointInfo endpointInfo = (EndpointInfo)map.get(coordinate);
        if (endpointInfo == null) {
            endpointInfo = new EndpointInfo();
            map.put(coordinate, endpointInfo);
        }
        endpointInfo.addEndpoint(bl);
    }

    private static class EndpointInfo {
        boolean isClosed = false;
        int degree = 0;

        public void addEndpoint(boolean bl) {
            ++this.degree;
            this.isClosed |= bl;
        }
    }
}

