/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.IntervalSize;
import com.vividsolutions.jts.index.quadtree.Node;
import com.vividsolutions.jts.index.quadtree.NodeBase;
import com.vividsolutions.jts.util.Assert;

public class Root
extends NodeBase {
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    public void insert(Envelope envelope, Object object) {
        int n = Root.getSubnodeIndex(envelope, origin);
        if (n == -1) {
            this.add(object);
            return;
        }
        Node node = this.subnode[n];
        if (node == null || !node.getEnvelope().contains(envelope)) {
            Node node2;
            this.subnode[n] = node2 = Node.createExpanded(node, envelope);
        }
        this.insertContained(this.subnode[n], envelope, object);
    }

    private void insertContained(Node node, Envelope envelope, Object object) {
        Assert.isTrue(node.getEnvelope().contains(envelope));
        boolean bl = IntervalSize.isZeroWidth(envelope.getMinX(), envelope.getMaxX());
        boolean bl2 = IntervalSize.isZeroWidth(envelope.getMinY(), envelope.getMaxY());
        NodeBase nodeBase = bl || bl2 ? node.find(envelope) : node.getNode(envelope);
        nodeBase.add(object);
    }

    @Override
    protected boolean isSearchMatch(Envelope envelope) {
        return true;
    }
}

