/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ArrayListVisitor;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Root;
import java.util.List;

public class Quadtree
implements SpatialIndex {
    private Root root = new Root();
    private double minExtent = 1.0;

    public static Envelope ensureExtent(Envelope envelope, double d) {
        double d2 = envelope.getMinX();
        double d3 = envelope.getMaxX();
        double d4 = envelope.getMinY();
        double d5 = envelope.getMaxY();
        if (d2 != d3 && d4 != d5) {
            return envelope;
        }
        if (d2 == d3) {
            d3 = (d2 -= d / 2.0) + d / 2.0;
        }
        if (d4 == d5) {
            d5 = (d4 -= d / 2.0) + d / 2.0;
        }
        return new Envelope(d2, d3, d4, d5);
    }

    @Override
    public void insert(Envelope envelope, Object object) {
        this.collectStats(envelope);
        Envelope envelope2 = Quadtree.ensureExtent(envelope, this.minExtent);
        this.root.insert(envelope2, object);
    }

    @Override
    public boolean remove(Envelope envelope, Object object) {
        Envelope envelope2 = Quadtree.ensureExtent(envelope, this.minExtent);
        return this.root.remove(envelope2, object);
    }

    @Override
    public List query(Envelope envelope) {
        ArrayListVisitor arrayListVisitor = new ArrayListVisitor();
        this.query(envelope, arrayListVisitor);
        return arrayListVisitor.getItems();
    }

    @Override
    public void query(Envelope envelope, ItemVisitor itemVisitor) {
        this.root.visit(envelope, itemVisitor);
    }

    private void collectStats(Envelope envelope) {
        double d;
        double d2 = envelope.getWidth();
        if (d2 < this.minExtent && d2 > 0.0) {
            this.minExtent = d2;
        }
        if ((d = envelope.getHeight()) < this.minExtent && d > 0.0) {
            this.minExtent = d;
        }
    }
}

