/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.gui.DialogPrompter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class GeographicReader
extends AbstractReader
implements OdConstants {
    protected static CoordinateReferenceSystem wgs84;
    private final GeographicHandler handler;
    private final GeographicHandler[] defaultHandlers;
    protected final Map<LatLon, Node> nodes = new HashMap<LatLon, Node>();
    protected CoordinateReferenceSystem crs;
    protected MathTransform transform;

    public GeographicReader(GeographicHandler handler, GeographicHandler[] defaultHandlers) {
        this.handler = handler;
        this.defaultHandlers = defaultHandlers;
    }

    protected Node getNode(Point p, LatLon key) {
        Node n = this.nodes.get(key);
        if (n == null && this.handler != null && this.handler.checkNodeProximity()) {
            LatLon ll = new LatLon(p.getY(), p.getX());
            for (Node node : this.nodes.values()) {
                if (!node.getCoor().equalsEpsilon(ll)) continue;
                return node;
            }
        }
        return n;
    }

    protected Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        return this.createOrGetNode(p, null);
    }

    protected Node createOrGetNode(Point p, String ele) throws MismatchedDimensionException, TransformException {
        LatLon key;
        Point p2 = (Point)JTS.transform(p, this.transform);
        Node n = this.getNode(p2, key = new LatLon(p2.getY(), p2.getX()));
        if (n == null) {
            n = new Node(key);
            if (ele != null) {
                n.put("ele", ele);
            }
            if (this.handler == null || this.handler.useNodeMap()) {
                this.nodes.put(key, n);
            }
            this.ds.addPrimitive((OsmPrimitive)n);
        } else if (n.getDataSet() == null) {
            this.ds.addPrimitive((OsmPrimitive)n);
        }
        return n;
    }

    protected <T extends OsmPrimitive> T addOsmPrimitive(T p) {
        this.ds.addPrimitive(p);
        return p;
    }

    protected final Way createWay() {
        return this.addOsmPrimitive(new Way());
    }

    protected final Way createWay(LineString ls) {
        Way w = this.createWay();
        if (ls != null) {
            for (int i = 0; i < ls.getNumPoints(); ++i) {
                try {
                    w.addNode(this.createOrGetNode(ls.getPointN(i)));
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        return w;
    }

    protected final Relation createMultipolygon() {
        Relation r = new Relation();
        r.put("type", "multipolygon");
        return this.addOsmPrimitive(r);
    }

    protected final void addWayToMp(Relation r, String role, Way w) {
        r.addMember(new RelationMember(role, (OsmPrimitive)w));
    }

    protected static final boolean warnLenientMethod(final Component parent, final CoordinateReferenceSystem crs) {
        return new DialogPrompter(){

            @Override
            protected ExtendedDialog buildDialog() {
                ExtendedDialog dlg = new ExtendedDialog(parent, I18n.tr((String)"Cannot transform to WGS84", (Object[])new Object[0]), new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Continue", (Object[])new Object[0])});
                dlg.setContent("<html>" + I18n.tr((String)"JOSM was unable to find a strict mathematical transformation between ''{0}'' and WGS84.<br /><br />Do you want to try a <i>lenient</i> method, which will perform a non-precise transformation (<b>with location errors up to 1 km</b>) ?<br/><br/>If so, <b>do NOT upload</b> such data to OSM !", (Object[])new Object[]{crs.getName()}) + "</html>");
                dlg.setButtonIcons(new Icon[]{ImageProvider.get((String)"cancel"), ImageProvider.overlay((Icon)ImageProvider.get((String)"ok"), (Icon)new ImageIcon(ImageProvider.get((String)"warning-small").getImage().getScaledInstance(10, 10, 4)), (ImageProvider.OverlayPosition)ImageProvider.OverlayPosition.SOUTHEAST)});
                dlg.setToolTipTexts(new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Try lenient method", (Object[])new Object[0])});
                dlg.setIcon(2);
                dlg.setCancelButton(new Integer[]{1});
                return dlg;
            }
        }.promptInEdt().getValue() != 2;
    }

    private static final void compareDebug(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        Integer dim2;
        Integer dim1;
        System.out.println("-- COMPARING " + crs1.getName() + " WITH " + crs2.getName() + " --");
        GeographicReader.compareDebug("class", crs1.getClass(), crs2.getClass());
        CoordinateSystem cs1 = crs1.getCoordinateSystem();
        CoordinateSystem cs2 = crs2.getCoordinateSystem();
        if (!GeographicReader.compareDebug("cs", cs1, cs2) && GeographicReader.compareDebug("cs.dim", dim1 = Integer.valueOf(cs1.getDimension()), dim2 = Integer.valueOf(cs2.getDimension()))) {
            for (int i = 0; i < dim1; ++i) {
                GeographicReader.compareDebug("cs.axis" + i, cs1.getAxis(i), cs1.getAxis(i));
            }
        }
        if (crs1 instanceof AbstractSingleCRS) {
            Datum datum2;
            Datum datum1 = ((AbstractSingleCRS)crs1).getDatum();
            if (!GeographicReader.compareDebug("datum", datum1, datum2 = ((AbstractSingleCRS)crs2).getDatum())) {
                AbstractIdentifiedObject adatum1 = (AbstractIdentifiedObject)((Object)datum1);
                AbstractIdentifiedObject adatum2 = (AbstractIdentifiedObject)((Object)datum2);
                GeographicReader.compareDebug("datum.name1", adatum1.nameMatches(adatum2.getName().getCode()), adatum1.getName(), adatum2.getName());
                GeographicReader.compareDebug("datum.name2", adatum2.nameMatches(adatum1.getName().getCode()), adatum2.getName(), adatum1.getName());
            }
            if (crs1 instanceof AbstractDerivedCRS) {
                AbstractDerivedCRS adcrs1 = (AbstractDerivedCRS)crs1;
                AbstractDerivedCRS adcrs2 = (AbstractDerivedCRS)crs2;
                GeographicReader.compareDebug("baseCRS", adcrs1.getBaseCRS(), adcrs2.getBaseCRS());
                GeographicReader.compareDebug("conversionFromBase", adcrs1.getConversionFromBase(), adcrs2.getConversionFromBase());
            }
        }
        System.out.println("-- COMPARING FINISHED --");
    }

    private static final boolean compareDebug(String text, Object o1, Object o2) {
        return GeographicReader.compareDebug(text, o1.equals(o2), o1, o2);
    }

    private static final boolean compareDebug(String text, IdentifiedObject o1, IdentifiedObject o2) {
        return GeographicReader.compareDebug(text, (AbstractIdentifiedObject)o1, (AbstractIdentifiedObject)o2);
    }

    private static final boolean compareDebug(String text, AbstractIdentifiedObject o1, AbstractIdentifiedObject o2) {
        return GeographicReader.compareDebug(text, o1.equals(o2, false), o1, o2);
    }

    private static final boolean compareDebug(String text, boolean result, Object o1, Object o2) {
        System.out.println(text + ": " + result + "(" + o1 + ", " + o2 + ")");
        return result;
    }

    protected void findMathTransform(Component parent, boolean findSimiliarCrs) throws FactoryException, UserCancelException, GeoMathTransformException {
        block20: {
            try {
                this.transform = CRS.findMathTransform(this.crs, wgs84);
            }
            catch (OperationNotFoundException e) {
                System.out.println(this.crs.getName() + ": " + e.getMessage());
                if (findSimiliarCrs) {
                    ArrayList<CoordinateReferenceSystem> candidates = new ArrayList<CoordinateReferenceSystem>();
                    for (String code : CRS.getAuthorityFactory(false).getAuthorityCodes(ProjectedCRS.class)) {
                        CoordinateReferenceSystem candidate = CRS.decode(code);
                        if (!(candidate instanceof AbstractCRS) || !(this.crs instanceof AbstractIdentifiedObject)) continue;
                        Hints.putSystemDefault(Hints.COMPARISON_TOLERANCE, Main.pref.getDouble("opendata.crs.comparison_tolerance", DEFAULT_CRS_COMPARISON_TOLERANCE.doubleValue()));
                        if (((AbstractCRS)candidate).equals((AbstractIdentifiedObject)((Object)this.crs), false)) {
                            System.out.println("Found a potential CRS: " + candidate.getName());
                            candidates.add(candidate);
                        } else if (Main.pref.getBoolean("opendata.crs.comparison_debug", false)) {
                            GeographicReader.compareDebug(this.crs, candidate);
                        }
                        Hints.removeSystemDefault(Hints.COMPARISON_TOLERANCE);
                    }
                    if (candidates.size() > 1) {
                        System.err.println("Found several potential CRS.");
                    }
                    if (candidates.size() > 0) {
                        CoordinateReferenceSystem newCRS = (CoordinateReferenceSystem)candidates.get(0);
                        try {
                            this.transform = CRS.findMathTransform(newCRS, wgs84, false);
                        }
                        catch (OperationNotFoundException ex) {
                            System.err.println(newCRS.getName() + ": " + e.getMessage());
                        }
                    }
                }
                if (this.transform != null) break block20;
                if (this.handler != null) {
                    try {
                        this.transform = this.handler.findMathTransform(this.crs, wgs84, false);
                    }
                    catch (OperationNotFoundException ex) {
                        System.out.println(this.crs.getName() + ": " + ex.getMessage());
                    }
                } else {
                    for (GeographicHandler geoHandler : this.defaultHandlers) {
                        try {
                            this.transform = geoHandler.findMathTransform(this.crs, wgs84, false);
                            if (this.transform == null) continue;
                            break;
                        }
                        catch (OperationNotFoundException ex) {
                            System.out.println(this.crs.getName() + ": " + ex.getMessage());
                        }
                    }
                }
                if (this.transform != null) break block20;
                if (GeographicReader.warnLenientMethod(parent, this.crs)) {
                    throw new UserCancelException();
                }
                System.out.println("Searching for a lenient math transform.");
                this.transform = CRS.findMathTransform(this.crs, wgs84, true);
            }
        }
        if (this.transform == null) {
            throw new GeoMathTransformException("Unable to find math transform !");
        }
    }

    static {
        try {
            wgs84 = CRS.decode("EPSG:4326");
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }
}

