/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;

public class Envelope
implements Serializable {
    private static final long serialVersionUID = 5873921885273102420L;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;

    public int hashCode() {
        int n = 17;
        n = 37 * n + Coordinate.hashCode(this.minx);
        n = 37 * n + Coordinate.hashCode(this.maxx);
        n = 37 * n + Coordinate.hashCode(this.miny);
        n = 37 * n + Coordinate.hashCode(this.maxy);
        return n;
    }

    public static boolean intersects(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate3.x;
        double d2 = coordinate.x < coordinate2.x ? coordinate.x : coordinate2.x;
        if (d >= d2) {
            double d3 = coordinate3.x;
            double d4 = coordinate.x > coordinate2.x ? coordinate.x : coordinate2.x;
            if (d3 <= d4) {
                double d5 = coordinate3.y;
                double d6 = coordinate.y < coordinate2.y ? coordinate.y : coordinate2.y;
                if (d5 >= d6) {
                    double d7 = coordinate3.y;
                    double d8 = coordinate.y > coordinate2.y ? coordinate.y : coordinate2.y;
                    if (d7 <= d8) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean intersects(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = Math.min(coordinate3.x, coordinate4.x);
        double d2 = Math.max(coordinate3.x, coordinate4.x);
        double d3 = Math.min(coordinate.x, coordinate2.x);
        double d4 = Math.max(coordinate.x, coordinate2.x);
        if (d3 > d2) {
            return false;
        }
        if (d4 < d) {
            return false;
        }
        d = Math.min(coordinate3.y, coordinate4.y);
        d2 = Math.max(coordinate3.y, coordinate4.y);
        d3 = Math.min(coordinate.y, coordinate2.y);
        d4 = Math.max(coordinate.y, coordinate2.y);
        if (d3 > d2) {
            return false;
        }
        return !(d4 < d);
    }

    public Envelope() {
        this.init();
    }

    public Envelope(double d, double d2, double d3, double d4) {
        this.init(d, d2, d3, d4);
    }

    public Envelope(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate.x, coordinate2.x, coordinate.y, coordinate2.y);
    }

    public Envelope(Envelope envelope) {
        this.init(envelope);
    }

    public void init() {
        this.setToNull();
    }

    public void init(double d, double d2, double d3, double d4) {
        if (d < d2) {
            this.minx = d;
            this.maxx = d2;
        } else {
            this.minx = d2;
            this.maxx = d;
        }
        if (d3 < d4) {
            this.miny = d3;
            this.maxy = d4;
        } else {
            this.miny = d4;
            this.maxy = d3;
        }
    }

    public void init(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate.x, coordinate2.x, coordinate.y, coordinate2.y);
    }

    public void init(Envelope envelope) {
        this.minx = envelope.minx;
        this.maxx = envelope.maxx;
        this.miny = envelope.miny;
        this.maxy = envelope.maxy;
    }

    public void setToNull() {
        this.minx = 0.0;
        this.maxx = -1.0;
        this.miny = 0.0;
        this.maxy = -1.0;
    }

    public boolean isNull() {
        return this.maxx < this.minx;
    }

    public double getWidth() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxx - this.minx;
    }

    public double getHeight() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxy - this.miny;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public void expandToInclude(Coordinate coordinate) {
        this.expandToInclude(coordinate.x, coordinate.y);
    }

    public void expandBy(double d) {
        this.expandBy(d, d);
    }

    public void expandBy(double d, double d2) {
        if (this.isNull()) {
            return;
        }
        this.minx -= d;
        this.maxx += d;
        this.miny -= d2;
        this.maxy += d2;
        if (this.minx > this.maxx || this.miny > this.maxy) {
            this.setToNull();
        }
    }

    public void expandToInclude(double d, double d2) {
        if (this.isNull()) {
            this.minx = d;
            this.maxx = d;
            this.miny = d2;
            this.maxy = d2;
        } else {
            if (d < this.minx) {
                this.minx = d;
            }
            if (d > this.maxx) {
                this.maxx = d;
            }
            if (d2 < this.miny) {
                this.miny = d2;
            }
            if (d2 > this.maxy) {
                this.maxy = d2;
            }
        }
    }

    public void expandToInclude(Envelope envelope) {
        if (envelope.isNull()) {
            return;
        }
        if (this.isNull()) {
            this.minx = envelope.getMinX();
            this.maxx = envelope.getMaxX();
            this.miny = envelope.getMinY();
            this.maxy = envelope.getMaxY();
        } else {
            if (envelope.minx < this.minx) {
                this.minx = envelope.minx;
            }
            if (envelope.maxx > this.maxx) {
                this.maxx = envelope.maxx;
            }
            if (envelope.miny < this.miny) {
                this.miny = envelope.miny;
            }
            if (envelope.maxy > this.maxy) {
                this.maxy = envelope.maxy;
            }
        }
    }

    public Coordinate centre() {
        if (this.isNull()) {
            return null;
        }
        return new Coordinate((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0);
    }

    public Envelope intersection(Envelope envelope) {
        if (this.isNull() || envelope.isNull() || !this.intersects(envelope)) {
            return new Envelope();
        }
        double d = this.minx > envelope.minx ? this.minx : envelope.minx;
        double d2 = this.miny > envelope.miny ? this.miny : envelope.miny;
        double d3 = this.maxx < envelope.maxx ? this.maxx : envelope.maxx;
        double d4 = this.maxy < envelope.maxy ? this.maxy : envelope.maxy;
        return new Envelope(d, d3, d2, d4);
    }

    public boolean intersects(Envelope envelope) {
        if (this.isNull() || envelope.isNull()) {
            return false;
        }
        return !(envelope.minx > this.maxx || envelope.maxx < this.minx || envelope.miny > this.maxy || envelope.maxy < this.miny);
    }

    public boolean intersects(Coordinate coordinate) {
        return this.intersects(coordinate.x, coordinate.y);
    }

    public boolean intersects(double d, double d2) {
        if (this.isNull()) {
            return false;
        }
        return !(d > this.maxx || d < this.minx || d2 > this.maxy || d2 < this.miny);
    }

    public boolean contains(Envelope envelope) {
        return this.covers(envelope);
    }

    public boolean contains(Coordinate coordinate) {
        return this.covers(coordinate);
    }

    public boolean contains(double d, double d2) {
        return this.covers(d, d2);
    }

    public boolean covers(double d, double d2) {
        if (this.isNull()) {
            return false;
        }
        return d >= this.minx && d <= this.maxx && d2 >= this.miny && d2 <= this.maxy;
    }

    public boolean covers(Coordinate coordinate) {
        return this.covers(coordinate.x, coordinate.y);
    }

    public boolean covers(Envelope envelope) {
        if (this.isNull() || envelope.isNull()) {
            return false;
        }
        return envelope.getMinX() >= this.minx && envelope.getMaxX() <= this.maxx && envelope.getMinY() >= this.miny && envelope.getMaxY() <= this.maxy;
    }

    public double distance(Envelope envelope) {
        if (this.intersects(envelope)) {
            return 0.0;
        }
        double d = 0.0;
        if (this.maxx < envelope.minx) {
            d = envelope.minx - this.maxx;
        } else if (this.minx > envelope.maxx) {
            d = this.minx - envelope.maxx;
        }
        double d2 = 0.0;
        if (this.maxy < envelope.miny) {
            d2 = envelope.miny - this.maxy;
        } else if (this.miny > envelope.maxy) {
            d2 = this.miny - envelope.maxy;
        }
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        return Math.sqrt(d * d + d2 * d2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Envelope)) {
            return false;
        }
        Envelope envelope = (Envelope)object;
        if (this.isNull()) {
            return envelope.isNull();
        }
        return this.maxx == envelope.getMaxX() && this.maxy == envelope.getMaxY() && this.minx == envelope.getMinX() && this.miny == envelope.getMinY();
    }

    public String toString() {
        return "Env[" + this.minx + " : " + this.maxx + ", " + this.miny + " : " + this.maxy + "]";
    }
}

