/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SettingsDialog
extends ExtendedDialog {
    private JButton freezeReferenceButton;
    private JButton freezeSubjectButton;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JButton restoreReferenceButton;
    private JButton restoreSubjectButton;
    private JLabel referenceLayerLabel;
    private JPanel referencePanel;
    private JLabel referenceSelectionLabel;
    private JLabel subjectLayerLabel;
    private JPanel subjectPanel;
    private JLabel subjectSelectionLabel;
    JCheckBox distanceCheckBox;
    JSpinner distanceWeightSpinner;
    JSpinner distanceCutoffSpinner;
    JCheckBox stringCheckBox;
    JSpinner stringWeightSpinner;
    JSpinner stringCutoffSpinner;
    JTextField stringTextField;
    ArrayList<OsmPrimitive> subjectSelection = null;
    ArrayList<OsmPrimitive> referenceSelection = null;
    OsmDataLayer referenceLayer;
    DataSet subjectDataSet;
    OsmDataLayer subjectLayer;
    DataSet referenceDataSet;

    public SettingsDialog() {
        super(Main.parent, I18n.tr((String)"Configure conflation settings", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, false);
        this.initComponents();
    }

    private void initComponents() {
        this.referencePanel = new JPanel();
        this.referenceLayerLabel = new JLabel();
        this.referenceSelectionLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.restoreReferenceButton = new JButton((Action)((Object)new RestoreReferenceAction()));
        this.freezeReferenceButton = new JButton((Action)((Object)new FreezeReferenceAction()));
        this.subjectPanel = new JPanel();
        this.subjectLayerLabel = new JLabel();
        this.subjectSelectionLabel = new JLabel();
        this.jPanel5 = new JPanel();
        this.restoreSubjectButton = new JButton((Action)((Object)new RestoreSubjectAction()));
        this.freezeSubjectButton = new JButton((Action)((Object)new FreezeSubjectAction()));
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 3));
        this.referencePanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Reference", (Object[])new Object[0])));
        this.referencePanel.setLayout(new BoxLayout(this.referencePanel, 3));
        this.referenceLayerLabel.setText("(none)");
        this.referencePanel.add(this.referenceLayerLabel);
        this.referenceSelectionLabel.setText("Rel.:0 / Ways:0 / Nodes: 0");
        this.referencePanel.add(this.referenceSelectionLabel);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.restoreReferenceButton.setText(I18n.tr((String)"Restore", (Object[])new Object[0]));
        this.jPanel3.add(this.restoreReferenceButton);
        this.jPanel3.add(this.freezeReferenceButton);
        this.referencePanel.add(this.jPanel3);
        pnl.add(this.referencePanel);
        this.subjectPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Subject", (Object[])new Object[0])));
        this.subjectPanel.setLayout(new BoxLayout(this.subjectPanel, 3));
        this.subjectLayerLabel.setText("(none)");
        this.subjectPanel.add(this.subjectLayerLabel);
        this.subjectSelectionLabel.setText("Rel.:0 / Ways:0 / Nodes: 0");
        this.subjectPanel.add(this.subjectSelectionLabel);
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 2));
        this.restoreSubjectButton.setText(I18n.tr((String)"Restore", (Object[])new Object[0]));
        this.jPanel5.add(this.restoreSubjectButton);
        this.freezeSubjectButton.setText(I18n.tr((String)"Freeze", (Object[])new Object[0]));
        this.jPanel5.add(this.freezeSubjectButton);
        this.subjectPanel.add(this.jPanel5);
        pnl.add(this.subjectPanel);
        JPanel costsPanel = new JPanel();
        costsPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Costs", (Object[])new Object[0])));
        costsPanel.setLayout(new GridBagLayout());
        costsPanel.add(GBC.glue((int)1, (int)1), GBC.std());
        costsPanel.add((Component)new JLabel(I18n.tr((String)"Weight", (Object[])new Object[0])), GBC.std());
        costsPanel.add((Component)new JLabel(I18n.tr((String)"Cutoff", (Object[])new Object[0])), GBC.eol());
        this.distanceCheckBox = new JCheckBox();
        this.distanceCheckBox.setSelected(true);
        this.distanceCheckBox.setText(I18n.tr((String)"Distance", (Object[])new Object[0]));
        costsPanel.add((Component)this.distanceCheckBox, GBC.std());
        this.distanceWeightSpinner = new JSpinner(new SpinnerNumberModel((Number)1.0, null, null, (Number)1.0));
        costsPanel.add((Component)this.distanceWeightSpinner, GBC.std());
        this.distanceCutoffSpinner = new JSpinner(new SpinnerNumberModel((Number)100.0, null, null, (Number)1.0));
        costsPanel.add((Component)this.distanceCutoffSpinner, GBC.eol());
        this.stringCheckBox = new JCheckBox();
        this.stringCheckBox.setSelected(false);
        this.stringCheckBox.setEnabled(false);
        this.stringCheckBox.setText(I18n.tr((String)"String", (Object[])new Object[0]));
        costsPanel.add((Component)this.stringCheckBox, GBC.std());
        this.stringWeightSpinner = new JSpinner(new SpinnerNumberModel((Number)10.0, null, null, (Number)1.0));
        costsPanel.add((Component)this.stringWeightSpinner, GBC.std());
        this.stringCutoffSpinner = new JSpinner(new SpinnerNumberModel((Number)100.0, null, null, (Number)1.0));
        costsPanel.add((Component)this.stringCutoffSpinner, GBC.eol());
        this.stringTextField = new JTextField("name", 14);
        costsPanel.add((Component)this.stringTextField, GBC.std());
        costsPanel.setEnabled(false);
        pnl.add(costsPanel);
        this.setContent(pnl);
        this.setupDialog();
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex == 0) {
            // empty if block
        }
    }

    public ConflationSettings getSettings() {
        ConflationSettings settings = new ConflationSettings();
        settings.setReferenceDataSet(this.referenceDataSet);
        settings.setReferenceLayer(this.referenceLayer);
        settings.setReferenceSelection(this.referenceSelection);
        settings.setSubjectDataSet(this.subjectDataSet);
        settings.setSubjectLayer(this.subjectLayer);
        settings.setSubjectSelection(this.subjectSelection);
        settings.distanceCutoff = (Double)this.distanceCutoffSpinner.getValue();
        settings.distanceWeight = this.distanceCheckBox.isSelected() ? (Double)this.distanceWeightSpinner.getValue() : 0.0;
        settings.stringCutoff = (Double)this.stringCutoffSpinner.getValue();
        settings.stringWeight = this.stringCheckBox.isSelected() ? (Double)this.stringWeightSpinner.getValue() : 0.0;
        settings.keyString = this.stringTextField.getText();
        return settings;
    }

    public void setSettings(ConflationSettings settings) {
        this.referenceDataSet = settings.getReferenceDataSet();
        this.referenceLayer = settings.getReferenceLayer();
        this.referenceSelection = settings.getReferenceSelection();
        this.subjectDataSet = settings.getSubjectDataSet();
        this.subjectLayer = settings.getSubjectLayer();
        this.subjectSelection = settings.getSubjectSelection();
        this.update();
    }

    void update() {
        int numNodes = 0;
        int numWays = 0;
        int numRelations = 0;
        if (this.subjectSelection != null) {
            for (OsmPrimitive p : this.subjectSelection) {
                if (p instanceof Node) {
                    ++numNodes;
                    continue;
                }
                if (p instanceof Way) {
                    ++numWays;
                    continue;
                }
                if (!(p instanceof Relation)) continue;
                ++numRelations;
            }
            this.subjectLayerLabel.setText(this.subjectLayer.getName());
            this.subjectSelectionLabel.setText(String.format("Rel.: %d / Ways: %d / Nodes: %d", numRelations, numWays, numNodes));
        }
        numNodes = 0;
        numWays = 0;
        numRelations = 0;
        if (this.referenceSelection != null) {
            for (OsmPrimitive p : this.referenceSelection) {
                if (p instanceof Node) {
                    ++numNodes;
                    continue;
                }
                if (p instanceof Way) {
                    ++numWays;
                    continue;
                }
                if (!(p instanceof Relation)) continue;
                ++numRelations;
            }
            this.referenceLayerLabel.setText(this.referenceLayer.getName());
            this.referenceSelectionLabel.setText(String.format("Rel.: %d / Ways: %d / Nodes: %d", numRelations, numWays, numNodes));
        }
    }

    class FreezeReferenceAction
    extends JosmAction {
        public FreezeReferenceAction() {
            super(I18n.tr((String)"Freeze", (Object[])new Object[0]), null, I18n.tr((String)"Freeze subject selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (SettingsDialog.this.referenceDataSet == null || SettingsDialog.this.referenceDataSet == Main.main.getCurrentDataSet()) {
                // empty if block
            }
            SettingsDialog.this.referenceDataSet = Main.main.getCurrentDataSet();
            SettingsDialog.this.referenceLayer = Main.main.getEditLayer();
            if (SettingsDialog.this.referenceDataSet == null || SettingsDialog.this.referenceLayer == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No valid OSM data layer present.", (Object[])new Object[0]), I18n.tr((String)"Error freezing selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.referenceSelection = new ArrayList(SettingsDialog.this.referenceDataSet.getSelected());
            if (SettingsDialog.this.referenceSelection.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nothing is selected, please try again.", (Object[])new Object[0]), I18n.tr((String)"Empty selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.update();
        }
    }

    class FreezeSubjectAction
    extends JosmAction {
        public FreezeSubjectAction() {
            super(I18n.tr((String)"Freeze", (Object[])new Object[0]), null, I18n.tr((String)"Freeze subject selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (SettingsDialog.this.subjectDataSet == null || SettingsDialog.this.subjectDataSet == Main.main.getCurrentDataSet()) {
                // empty if block
            }
            SettingsDialog.this.subjectDataSet = Main.main.getCurrentDataSet();
            SettingsDialog.this.subjectLayer = Main.main.getEditLayer();
            if (SettingsDialog.this.subjectDataSet == null || SettingsDialog.this.subjectLayer == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No valid OSM data layer present.", (Object[])new Object[0]), I18n.tr((String)"Error freezing selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.subjectSelection = new ArrayList(SettingsDialog.this.subjectDataSet.getSelected());
            if (SettingsDialog.this.subjectSelection.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nothing is selected, please try again.", (Object[])new Object[0]), I18n.tr((String)"Empty selection", (Object[])new Object[0]), 0);
                return;
            }
            SettingsDialog.this.update();
        }
    }

    class RestoreReferenceAction
    extends JosmAction {
        public RestoreReferenceAction() {
            super(I18n.tr((String)"Restore", (Object[])new Object[0]), null, I18n.tr((String)"Restore reference selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (SettingsDialog.this.referenceLayer != null && SettingsDialog.this.referenceDataSet != null && SettingsDialog.this.referenceSelection != null && !SettingsDialog.this.referenceSelection.isEmpty()) {
                Main.map.mapView.setActiveLayer((Layer)SettingsDialog.this.referenceLayer);
                SettingsDialog.this.referenceLayer.setVisible(true);
                SettingsDialog.this.referenceDataSet.setSelected(SettingsDialog.this.referenceSelection);
            }
        }
    }

    class RestoreSubjectAction
    extends JosmAction {
        public RestoreSubjectAction() {
            super(I18n.tr((String)"Restore", (Object[])new Object[0]), null, I18n.tr((String)"Restore subject selection", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (SettingsDialog.this.subjectLayer != null && SettingsDialog.this.subjectDataSet != null && SettingsDialog.this.subjectSelection != null && !SettingsDialog.this.subjectSelection.isEmpty()) {
                Main.map.mapView.setActiveLayer((Layer)SettingsDialog.this.subjectLayer);
                SettingsDialog.this.subjectLayer.setVisible(true);
                SettingsDialog.this.subjectDataSet.setSelected(SettingsDialog.this.subjectSelection);
            }
        }
    }
}

