/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import com.vividsolutions.jump.feature.AbstractBasicFeature;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.jts.JTSUtils;

public class OsmFeature
extends AbstractBasicFeature {
    private Object[] attributes;
    private OsmPrimitive primitive;

    public OsmFeature(OsmPrimitive prim) {
        super(new FeatureSchema());
        this.primitive = prim;
        Map keys = prim.getKeys();
        this.attributes = new Object[keys.size() + 1];
        this.getSchema().addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        for (String key : keys.keySet()) {
            this.getSchema().addAttribute(key, AttributeType.STRING);
            this.setAttribute(key, keys.get(key));
        }
        JTSUtils conversion = new JTSUtils();
        this.setGeometry(conversion.convert(prim));
    }

    @Override
    public void setAttributes(Object[] attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setAttribute(int attributeIndex, Object newAttribute) {
        this.attributes[attributeIndex] = newAttribute;
    }

    @Override
    public Object getAttribute(int i) {
        return this.attributes[i];
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes;
    }

    public OsmPrimitive getPrimitive() {
        return this.primitive;
    }

    @Override
    public int getID() {
        return (int)this.primitive.getId();
    }
}

