/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.util.HashSet;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidate;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidateList;
import org.openstreetmap.josm.plugins.conflation.ConflationListChangedListener;
import org.openstreetmap.josm.tools.I18n;

class MatchTableModel
extends AbstractTableModel
implements ConflationListChangedListener {
    private ConflationCandidateList candidates = null;
    private static final String[] columnNames = new String[]{I18n.tr((String)"Reference", (Object[])new Object[0]), I18n.tr((String)"Subject", (Object[])new Object[0]), "Distance (m)", "Score", "Tags"};

    MatchTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.candidates == null) {
            return 0;
        }
        return this.candidates.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.candidates == null) {
            return null;
        }
        ConflationCandidate c = this.candidates.get(row);
        if (col == 0) {
            return c.getReferenceObject();
        }
        if (col == 1) {
            return c.getSubjectObject();
        }
        if (col == 2) {
            return c.getDistance();
        }
        if (col == 3) {
            return c.getScore();
        }
        if (col == 4) {
            HashSet<OsmPrimitive> set = new HashSet<OsmPrimitive>();
            set.add(c.getReferenceObject());
            set.add(c.getSubjectObject());
            TagCollection tags = TagCollection.unionOfAllPrimitives(set);
            Set keys = tags.getKeysWithMultipleValues();
            if (keys.isEmpty()) {
                return "No conflicts!";
            }
            return "Conflicts!";
        }
        return 0;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public ConflationCandidateList getCandidates() {
        return this.candidates;
    }

    public void setCandidates(ConflationCandidateList candidates) {
        this.candidates = candidates;
        this.fireTableDataChanged();
    }

    @Override
    public void conflationListChanged(ConflationCandidateList list) {
        this.fireTableDataChanged();
    }
}

