/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import com.vividsolutions.jcs.conflate.polygonmatch.BasicFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.CentroidDistanceMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.ChainMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.IdenticalFeatureFilter;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jcs.conflate.polygonmatch.OneToOneFCMatchFinder;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidate;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidateList;
import org.openstreetmap.josm.plugins.conflation.ConflationLayer;
import org.openstreetmap.josm.plugins.conflation.ConflationListChangedListener;
import org.openstreetmap.josm.plugins.conflation.ConflationPlugin;
import org.openstreetmap.josm.plugins.conflation.ConflationSettings;
import org.openstreetmap.josm.plugins.conflation.MatchTableModel;
import org.openstreetmap.josm.plugins.conflation.OsmFeature;
import org.openstreetmap.josm.plugins.conflation.SettingsDialog;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ConflationToggleDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
SelectionChangedListener,
DataSetListener,
ConflationListChangedListener {
    public static final String PREF_PREFIX = "conflation";
    JTable resultsTable;
    ConflationLayer conflationLayer;
    MatchTableModel tableModel;
    ConflationCandidateList candidates = new ConflationCandidateList();
    ConflationSettings settings;
    SettingsDialog settingsDialog = new SettingsDialog();

    public ConflationToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, ConflationPlugin conflationPlugin) {
        super(I18n.tr((String)name, (Object[])new Object[0]), iconName, I18n.tr((String)tooltip, (Object[])new Object[0]), shortcut, preferredHeight);
        this.settingsDialog.setModalityType(Dialog.ModalityType.MODELESS);
        this.settingsDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (ConflationToggleDialog.this.settingsDialog.getValue() == 1) {
                    ConflationToggleDialog.this.settings = ConflationToggleDialog.this.settingsDialog.getSettings();
                    ConflationToggleDialog.this.performConflation();
                }
            }
        });
        this.tableModel = new MatchTableModel();
        this.resultsTable = new JTable(this.tableModel);
        this.resultsTable.getSelectionModel().addListSelectionListener(new MatchListSelectionHandler());
        this.resultsTable.getColumnModel().getSelectionModel().addListSelectionListener(new MatchListSelectionHandler());
        this.resultsTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new OsmPrimitivRenderer());
        this.resultsTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new OsmPrimitivRenderer());
        this.resultsTable.getColumnModel().getColumn(4).setCellRenderer(new ColorTableCellRenderer("Tags"));
        this.resultsTable.setSelectionMode(0);
        this.createLayout(this.resultsTable, true, Arrays.asList(new SideButton((Action)((Object)new ConfigureAction()), true), new SideButton((Action)((Object)new ConflationAction()), true)));
    }

    @Override
    public void conflationListChanged(ConflationCandidateList list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        List prims = event.getPrimitives();
        block0: for (OsmPrimitive p : prims) {
            for (ConflationCandidate c : this.candidates) {
                if (!c.getReferenceObject().equals((Object)p) && !c.getSubjectObject().equals((Object)p)) continue;
                this.candidates.remove(c);
                continue block0;
            }
        }
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void dataChanged(DataChangedEvent event) {
    }

    private FeatureSchema createSchema(Collection<OsmPrimitive> prims) {
        HashSet keys = new HashSet();
        for (OsmPrimitive prim : prims) {
            keys.addAll(prim.getKeys().keySet());
        }
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("__GEOMETRY__", AttributeType.GEOMETRY);
        for (String key : keys) {
            schema.addAttribute(key, AttributeType.STRING);
        }
        return schema;
    }

    private FeatureCollection createFeatureCollection(Collection<OsmPrimitive> prims) {
        FeatureDataset dataset = new FeatureDataset(this.createSchema(prims));
        for (OsmPrimitive prim : prims) {
            dataset.add(new OsmFeature(prim));
        }
        return dataset;
    }

    private ConflationCandidateList generateCandidates(ConflationSettings settings) {
        JosmTaskMonitor monitor = new JosmTaskMonitor();
        monitor.beginTask("Generating conflation candidates");
        HashSet<OsmPrimitive> allPrimitives = new HashSet<OsmPrimitive>();
        allPrimitives.addAll(settings.getReferenceSelection());
        allPrimitives.addAll(settings.getSubjectSelection());
        FeatureCollection allFeatures = this.createFeatureCollection(allPrimitives);
        FeatureDataset refColl = new FeatureDataset(allFeatures.getFeatureSchema());
        FeatureDataset subColl = new FeatureDataset(allFeatures.getFeatureSchema());
        for (Feature f : allFeatures.getFeatures()) {
            OsmFeature osmFeature = (OsmFeature)f;
            if (settings.getReferenceSelection().contains(osmFeature.getPrimitive())) {
                refColl.add(osmFeature);
            }
            if (!settings.getSubjectSelection().contains(osmFeature.getPrimitive())) continue;
            subColl.add(osmFeature);
        }
        Envelope envelope = refColl.getEnvelope();
        envelope.expandToInclude(subColl.getEnvelope());
        double maxDistance = Point2D.distance(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
        CentroidDistanceMatcher centroid = new CentroidDistanceMatcher();
        centroid.setMaxDistance(maxDistance);
        IdenticalFeatureFilter identical = new IdenticalFeatureFilter();
        FeatureMatcher[] matchers = new FeatureMatcher[]{centroid, identical};
        ChainMatcher chain = new ChainMatcher(matchers);
        BasicFCMatchFinder basicFinder = new BasicFCMatchFinder(chain);
        OneToOneFCMatchFinder finder = new OneToOneFCMatchFinder(basicFinder);
        Map map = finder.match(refColl, subColl, monitor);
        monitor.subTask("Finishing conflation candidate list");
        ConflationCandidateList list = new ConflationCandidateList();
        for (Map.Entry entry : map.entrySet()) {
            OsmFeature target = (OsmFeature)entry.getKey();
            OsmFeature subject = (OsmFeature)((Matches)entry.getValue()).getTopMatch();
            list.add(new ConflationCandidate(target.getPrimitive(), subject.getPrimitive(), ((Matches)entry.getValue()).getTopScore()));
        }
        monitor.finishTask();
        monitor.close();
        return list;
    }

    private void performConflation() {
        this.candidates = this.generateCandidates(this.settings);
        this.tableModel.setCandidates(this.candidates);
        this.candidates.addConflationListChangedListener(this.tableModel);
        this.settings.getSubjectDataSet().addDataSetListener((DataSetListener)this);
        this.settings.getReferenceDataSet().addDataSetListener((DataSetListener)this);
        try {
            if (this.conflationLayer == null) {
                this.conflationLayer = new ConflationLayer();
                Main.main.addLayer((Layer)this.conflationLayer);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Main.parent, ex.toString(), "Error adding conflation layer", 0);
        }
        this.conflationLayer.setCandidates(this.candidates);
    }

    private class JosmTaskMonitor
    extends PleaseWaitProgressMonitor
    implements TaskMonitor {
        private JosmTaskMonitor() {
        }

        @Override
        public void report(String description) {
            this.subTask(description);
        }

        @Override
        public void report(int itemsDone, int totalItems, String itemDescription) {
            this.subTask(String.format("Processing %d of %d %s", itemsDone, totalItems, itemDescription));
        }

        @Override
        public void report(Exception exception) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void allowCancellationRequests() {
            this.setCancelable(true);
        }

        @Override
        public boolean isCancelRequested() {
            return this.isCanceled();
        }
    }

    class ConflationAction
    extends JosmAction {
        public ConflationAction() {
            super(I18n.tr((String)"Replace Geometry", (Object[])new Object[0]), null, I18n.tr((String)"Replace geometry", (Object[])new Object[0]), Shortcut.registerShortcut((String)"conflation:replace", (String)I18n.tr((String)"Conflation: {0}", (Object[])new Object[]{I18n.tr((String)"Replace", (Object[])new Object[0])}), (int)70, (int)5008), false);
        }

        public void actionPerformed(ActionEvent e) {
            ConflationCandidate c = ConflationToggleDialog.this.conflationLayer.getSelectedCandidate();
            if (ConflationToggleDialog.this.settings.getReferenceLayer() != ConflationToggleDialog.this.settings.getSubjectLayer()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Conflation between layers isn't supported yet.", (Object[])new Object[0]), I18n.tr((String)"Cannot conflate between layes", (Object[])new Object[0]), 0);
                return;
            }
            if (ReplaceGeometryUtils.replace((OsmPrimitive)c.getReferenceObject(), (OsmPrimitive)c.getSubjectObject())) {
                ConflationToggleDialog.this.candidates.remove(c);
            }
        }
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    class ColorTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private String columnName;

        public ColorTableCellRenderer(String column) {
            this.columnName = column;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object columnValue = table.getValueAt(row, table.getColumnModel().getColumnIndex(this.columnName));
            if (value != null) {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
                if (columnValue.equals("Conflicts!")) {
                    this.setBackground(Color.red);
                } else {
                    this.setBackground(Color.green);
                }
            }
            return this;
        }
    }

    class MatchListSelectionHandler
    implements ListSelectionListener {
        MatchListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int firstIndex = lsm.getMinSelectionIndex();
            int lastIndex = lsm.getMaxSelectionIndex();
            boolean isAdjusting = e.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (!lsm.isSelectionEmpty() && firstIndex == lastIndex && firstIndex < ConflationToggleDialog.this.candidates.size()) {
                ConflationCandidate c = ConflationToggleDialog.this.candidates.get(firstIndex);
                OsmPrimitive reference = c.getReferenceObject();
                OsmPrimitive subject = c.getSubjectObject();
                ConflationToggleDialog.this.conflationLayer.setSelectedCandidate(c);
                reference.getDataSet().clearSelection();
                subject.getDataSet().clearSelection();
                reference.getDataSet().addSelected(new PrimitiveId[]{reference});
                subject.getDataSet().addSelected(new PrimitiveId[]{subject});
                BoundingXYVisitor box = new BoundingXYVisitor();
                box.computeBoundingBox(Arrays.asList(reference, subject));
                if (box.getBounds() == null) {
                    return;
                }
                box.enlargeBoundingBox();
                Main.map.mapView.recalculateCenterScale(box);
            }
        }
    }

    public class ConfigureAction
    extends JosmAction {
        public ConfigureAction() {
            super(I18n.tr((String)"Configure", (Object[])new Object[0]), null, I18n.tr((String)"Configure conflation", (Object[])new Object[0]), Shortcut.registerShortcut((String)"conflation:configure", (String)I18n.tr((String)"Conflation: {0}", (Object[])new Object[]{I18n.tr((String)"Conflation", (Object[])new Object[0])}), (int)70, (int)5008), false);
        }

        public void actionPerformed(ActionEvent e) {
            ConflationToggleDialog.this.settingsDialog.setVisible(true);
        }
    }
}

