/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.conflation.ConflationCandidate;
import org.openstreetmap.josm.plugins.conflation.ConflationListChangedListener;

public class ConflationCandidateList
implements Iterable<ConflationCandidate> {
    private CopyOnWriteArrayList<ConflationListChangedListener> listeners = new CopyOnWriteArrayList();
    List<ConflationCandidate> candidates = new LinkedList<ConflationCandidate>();

    public boolean hasCandidate(ConflationCandidate c) {
        return this.hasCandidateForReference(c.getReferenceObject());
    }

    public boolean hasCandidate(OsmPrimitive referenceObject, OsmPrimitive subjectObject) {
        return this.hasCandidateForReference(referenceObject) || this.hasCandidateForSubject(subjectObject);
    }

    public boolean hasCandidateForReference(OsmPrimitive referenceObject) {
        return this.getCandidateByReference(referenceObject) != null;
    }

    public boolean hasCandidateForSubject(OsmPrimitive subjectObject) {
        return this.getCandidateBySubject(subjectObject) != null;
    }

    public ConflationCandidate getCandidateByReference(OsmPrimitive referenceObject) {
        for (ConflationCandidate c : this.candidates) {
            if (c.getReferenceObject() != referenceObject) continue;
            return c;
        }
        return null;
    }

    public ConflationCandidate getCandidateBySubject(OsmPrimitive subjectObject) {
        for (ConflationCandidate c : this.candidates) {
            if (c.getSubjectObject() != subjectObject) continue;
            return c;
        }
        return null;
    }

    @Override
    public Iterator<ConflationCandidate> iterator() {
        return this.candidates.iterator();
    }

    public void add(ConflationCandidate c) {
        this.candidates.add(c);
        this.fireSelectionChanged();
    }

    public int size() {
        return this.candidates.size();
    }

    public ConflationCandidate get(int index) {
        return this.candidates.get(index);
    }

    public ConflationCandidate remove(int index) {
        return this.candidates.remove(index);
    }

    public void clear() {
        this.candidates.clear();
        this.fireSelectionChanged();
    }

    public boolean remove(ConflationCandidate c) {
        boolean ret = this.candidates.remove(c);
        this.fireSelectionChanged();
        return ret;
    }

    public void addConflationListChangedListener(ConflationListChangedListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void fireSelectionChanged() {
        for (ConflationListChangedListener l : this.listeners) {
            l.conflationListChanged(this);
        }
    }
}

