/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.conflation.ConflationUtils;
import org.openstreetmap.josm.tools.I18n;

public class ConflationCandidate {
    OsmPrimitive referenceObject;
    OsmPrimitive subjectObject;
    double score;
    double distance;

    public ConflationCandidate(OsmPrimitive referenceObject, OsmPrimitive subjectObject, double score) {
        if (referenceObject == null || subjectObject == null) {
            throw new IllegalArgumentException(I18n.tr((String)"Invalid reference or subject", (Object[])new Object[0]));
        }
        this.referenceObject = referenceObject;
        this.subjectObject = subjectObject;
        this.score = score;
        this.distance = ConflationUtils.getCenter(referenceObject).distance(ConflationUtils.getCenter(subjectObject));
    }

    public OsmPrimitive getReferenceObject() {
        return this.referenceObject;
    }

    public OsmPrimitive getSubjectObject() {
        return this.subjectObject;
    }

    public Object getScore() {
        return this.score;
    }

    public Object getDistance() {
        return this.distance;
    }
}

