/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.FeatureMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class WeightedMatcher
implements FeatureMatcher {
    private Map matcherToWeightMap = new HashMap();

    public WeightedMatcher(Object[] matchersAndWeights) {
        Assert.isTrue((matchersAndWeights.length % 2 == 0 ? 1 : 0) != 0);
        for (int i = 0; i < matchersAndWeights.length; i += 2) {
            this.add((FeatureMatcher)matchersAndWeights[i + 1], ((Number)matchersAndWeights[i]).doubleValue());
        }
    }

    private void add(FeatureMatcher matcher, double weight) {
        Assert.isTrue((weight >= 0.0 ? 1 : 0) != 0);
        if (weight == 0.0) {
            return;
        }
        this.matcherToWeightMap.put(matcher, new Double(weight));
    }

    @Override
    public Matches match(Feature target, FeatureCollection candidates) {
        if (this.weightTotal() == 0.0) {
            return new Matches(candidates.getFeatureSchema());
        }
        Map matcherToMatchesMap = this.matcherToMatchesMap(target, candidates);
        Map featureToScoreMap = this.featureToScoreMap(matcherToMatchesMap);
        return this.toMatches(featureToScoreMap, candidates.getFeatureSchema());
    }

    private Matches toMatches(Map featureToScoreMap, FeatureSchema schema) {
        Matches matches = new Matches(schema);
        for (Feature feature : featureToScoreMap.keySet()) {
            double score = (Double)featureToScoreMap.get(feature);
            matches.add(feature, score);
        }
        return matches;
    }

    private Map matcherToMatchesMap(Feature feature, FeatureCollection candidates) {
        HashMap<FeatureMatcher, Matches> matcherToMatchesMap = new HashMap<FeatureMatcher, Matches>();
        for (FeatureMatcher matcher : this.matcherToWeightMap.keySet()) {
            if (this.normalizedWeight(matcher) == 0.0) continue;
            matcherToMatchesMap.put(matcher, matcher.match(feature, candidates));
        }
        return matcherToMatchesMap;
    }

    private Map featureToScoreMap(Map matcherToMatchesMap) {
        TreeMap featureToScoreMap = new TreeMap();
        for (FeatureMatcher matcher : matcherToMatchesMap.keySet()) {
            Matches matches = (Matches)matcherToMatchesMap.get(matcher);
            this.addToFeatureToScoreMap(matches, matcher, featureToScoreMap);
        }
        return featureToScoreMap;
    }

    private void addToFeatureToScoreMap(Matches matches, FeatureMatcher matcher, Map featureToScoreMap) {
        for (int i = 0; i < matches.size(); ++i) {
            double score = matches.getScore(i) * this.normalizedWeight(matcher);
            this.addToFeatureToScoreMap(matches.getFeature(i), score, featureToScoreMap);
        }
    }

    private void addToFeatureToScoreMap(Feature feature, double score, Map featureToScoreMap) {
        Double oldScore = (Double)featureToScoreMap.get(feature);
        if (oldScore == null) {
            oldScore = new Double(0.0);
        }
        featureToScoreMap.put(feature, new Double(oldScore + score));
    }

    private double normalizedWeight(FeatureMatcher matcher) {
        return (Double)this.matcherToWeightMap.get(matcher) / this.weightTotal();
    }

    private double weightTotal() {
        double weightTotal = 0.0;
        for (Double weight : this.matcherToWeightMap.values()) {
            weightTotal += weight.doubleValue();
        }
        return weightTotal;
    }
}

