/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.AreaFilterFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.DisambiguationMatch;
import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TargetUnioningFCMatchFinder
implements FCMatchFinder {
    private FCMatchFinder matchFinder;
    private int maxCompositeSize;
    private List lastTargetConstituents;
    private List lastUnionIDs;

    public TargetUnioningFCMatchFinder(int maxCompositeSize, FCMatchFinder matchFinder) {
        this.maxCompositeSize = maxCompositeSize;
        this.matchFinder = matchFinder;
    }

    @Override
    public Map match(FeatureCollection targetFC, FeatureCollection candidateFC, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        FeatureCollection compositeTargetFC = this.createCompositeFC(targetFC, monitor);
        Map compositeTargetFeatureToMatchesMap = this.matchFinder.match(compositeTargetFC, candidateFC, monitor);
        compositeTargetFeatureToMatchesMap = this.disambiguateCompositeTargetConstituents(compositeTargetFeatureToMatchesMap, candidateFC.getFeatureSchema(), monitor);
        this.createUnionIDs(compositeTargetFeatureToMatchesMap, monitor);
        Map filteredTargetToMatchesMap = this.splitCompositeTargets(compositeTargetFeatureToMatchesMap, monitor);
        Map targetToMatchesMap = AreaFilterFCMatchFinder.blankTargetToMatchesMap(targetFC.getFeatures(), candidateFC.getFeatureSchema());
        targetToMatchesMap.putAll(filteredTargetToMatchesMap);
        return targetToMatchesMap;
    }

    private void createUnionIDs(final Map compositeTargetFeatureToMatchesMap, TaskMonitor monitor) {
        monitor.report("Creating union IDs");
        ArrayList compositeTargets = new ArrayList(compositeTargetFeatureToMatchesMap.keySet());
        Collections.sort(compositeTargets, new Comparator(){

            public int compare(Object o1, Object o2) {
                double s2;
                double s1 = ((Matches)compositeTargetFeatureToMatchesMap.get(o1)).getTopScore();
                return s1 < (s2 = ((Matches)compositeTargetFeatureToMatchesMap.get(o2)).getTopScore()) ? -1 : (s1 > s2 ? 1 : 0);
            }
        });
        this.lastTargetConstituents = new ArrayList();
        this.lastUnionIDs = new ArrayList();
        int unionID = 0;
        for (int i = 0; i < compositeTargets.size(); ++i) {
            monitor.report(i + 1, compositeTargets.size(), "unions");
            CompositeFeature compositeTarget = (CompositeFeature)compositeTargets.get(i);
            if (compositeTarget.getFeatures().size() == 1) continue;
            ++unionID;
            for (Feature targetConstituent : compositeTarget.getFeatures()) {
                this.lastTargetConstituents.add(targetConstituent);
                this.lastUnionIDs.add(new Integer(unionID));
            }
        }
    }

    protected FeatureCollection createCompositeFC(FeatureCollection fc, TaskMonitor monitor) {
        FeatureDataset compositeFC = new FeatureDataset(fc.getFeatureSchema());
        Set composites = this.createCompositeSet(fc, monitor);
        this.add(composites, compositeFC, monitor);
        return new IndexedFeatureCollection(compositeFC);
    }

    protected Map disambiguateCompositeTargetConstituents(Map compositeTargetToMatchesMap, FeatureSchema candidateSchema, TaskMonitor monitor) {
        ArrayList targetConstituentsEncountered = new ArrayList();
        ArrayList<Feature> compositeTargets = new ArrayList<Feature>();
        ArrayList<Feature> candidates = new ArrayList<Feature>();
        ArrayList<Double> scores = new ArrayList<Double>();
        SortedSet matchSet = DisambiguationMatch.createDisambiguationMatches(compositeTargetToMatchesMap, monitor);
        monitor.report("Discarding inferior composite matches");
        int j = 0;
        block0: for (DisambiguationMatch match : matchSet) {
            monitor.report(++j, matchSet.size(), "matches");
            for (Feature targetConstituent : ((CompositeFeature)match.getTarget()).getFeatures()) {
                if (!targetConstituentsEncountered.contains(targetConstituent)) continue;
                continue block0;
            }
            compositeTargets.add(match.getTarget());
            candidates.add(match.getCandidate());
            scores.add(new Double(match.getScore()));
            targetConstituentsEncountered.addAll(((CompositeFeature)match.getTarget()).getFeatures());
        }
        HashMap newMap = new HashMap();
        for (int i = 0; i < compositeTargets.size(); ++i) {
            Matches matches = new Matches(candidateSchema);
            matches.add((Feature)candidates.get(i), (Double)scores.get(i));
            newMap.put(compositeTargets.get(i), matches);
        }
        return newMap;
    }

    private List featuresWithCommonEdge(Feature feature, FeatureCollection fc) {
        ArrayList<Feature> featuresWithCommonEdge = new ArrayList<Feature>();
        List candidates = fc.query(feature.getGeometry().getEnvelopeInternal());
        for (Feature candidate : candidates) {
            if (feature != candidate && !this.shareEdge(feature.getGeometry(), candidate.getGeometry())) continue;
            featuresWithCommonEdge.add(candidate);
        }
        return featuresWithCommonEdge;
    }

    protected boolean shareEdge(Geometry a, Geometry b) {
        Set aEdges = this.edges(a);
        Set bEdges = this.edges(b);
        for (Edge bEdge : bEdges) {
            if (!aEdges.contains(bEdge)) continue;
            return true;
        }
        return false;
    }

    private Set edges(Geometry g) {
        TreeSet<Edge> edges = new TreeSet<Edge>();
        for (Coordinate[] coordinates : CoordinateArrays.toCoordinateArrays(g, false)) {
            for (int j = 1; j < coordinates.length; ++j) {
                edges.add(new Edge(coordinates[j], coordinates[j - 1]));
            }
        }
        return edges;
    }

    protected Map splitCompositeTargets(Map compositeToMatchesMap, TaskMonitor monitor) {
        monitor.report("Splitting composites");
        int compositesProcessed = 0;
        int totalComposites = compositeToMatchesMap.size();
        HashMap<Feature, Object> newMap = new HashMap<Feature, Object>();
        Iterator i = compositeToMatchesMap.keySet().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            CompositeFeature composite = (CompositeFeature)i.next();
            monitor.report(++compositesProcessed, totalComposites, "composites");
            Matches matches = (Matches)compositeToMatchesMap.get(composite);
            for (Feature targetConstituent : composite.getFeatures()) {
                Assert.isTrue((!newMap.containsKey(targetConstituent) ? 1 : 0) != 0);
                newMap.put(targetConstituent, matches.clone());
            }
        }
        return newMap;
    }

    private Set createCompositeSet(FeatureCollection fc, TaskMonitor monitor) {
        monitor.report("Creating composites of adjacent features");
        int featuresProcessed = 0;
        int totalFeatures = fc.getFeatures().size();
        HashSet<CompositeFeature> composites = new HashSet<CompositeFeature>();
        Iterator<Feature> i = fc.getFeatures().iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature feature = i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features");
            List featuresWithCommonEdge = this.featuresWithCommonEdge(feature, fc);
            Iterator j = CollectionUtil.combinations(featuresWithCommonEdge, this.maxCompositeSize, feature).iterator();
            while (j.hasNext() && !monitor.isCancelRequested()) {
                List combination = (List)j.next();
                composites.add(new CompositeFeature(fc.getFeatureSchema(), combination));
            }
        }
        return composites;
    }

    private void add(Collection features, FeatureCollection fc, TaskMonitor monitor) {
        monitor.report("Building feature-collection");
        fc.addAll(features);
    }

    public Integer getUnionID(Feature target) {
        int i = this.lastTargetConstituents.indexOf(target);
        if (i == -1) {
            return null;
        }
        return (Integer)this.lastUnionIDs.get(i);
    }

    public static class CompositeFeature
    extends BasicFeature {
        private List features;
        private int hashCode;

        public CompositeFeature(FeatureSchema schema, List features) {
            super(schema);
            this.features = features;
            Geometry union = ((Feature)features.get(0)).getGeometry();
            this.hashCode = ((Feature)features.get(0)).hashCode();
            for (int i = 1; i < features.size(); ++i) {
                Feature feature = (Feature)features.get(i);
                union = union.union(feature.getGeometry());
                this.hashCode = Math.min(this.hashCode, feature.hashCode());
            }
            this.setGeometry(union);
        }

        public List getFeatures() {
            return this.features;
        }

        public boolean equals(Object obj) {
            Assert.isTrue((boolean)(obj instanceof CompositeFeature), (String)obj.getClass().toString());
            CompositeFeature other = (CompositeFeature)obj;
            if (this.features.size() != other.features.size()) {
                return false;
            }
            for (Feature myFeature : this.features) {
                if (other.features.contains(myFeature)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class Edge
    implements Comparable {
        private Coordinate p0;
        private Coordinate p1;

        public Edge(Coordinate a, Coordinate b) {
            if (a.compareTo((Object)b) < 1) {
                this.p0 = a;
                this.p1 = b;
            } else {
                this.p0 = b;
                this.p1 = a;
            }
        }

        public int compareTo(Object o) {
            Edge other = (Edge)o;
            int result = this.p0.compareTo((Object)other.p0);
            if (result != 0) {
                return result;
            }
            return this.p1.compareTo((Object)other.p1);
        }
    }
}

