/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Matches
implements FeatureCollection,
Cloneable {
    private FeatureDataset dataset;
    private ArrayList scores = new ArrayList();
    private Feature topMatch;
    private double topScore = 0.0;

    public Matches(FeatureSchema schema) {
        this.dataset = new FeatureDataset(schema);
    }

    protected Object clone() {
        Matches clone = new Matches(this.dataset.getFeatureSchema());
        for (int i = 0; i < this.size(); ++i) {
            clone.add(this.getFeature(i), this.getScore(i));
        }
        return clone;
    }

    public Matches(FeatureSchema schema, List features) {
        this(schema);
        for (Feature match : features) {
            this.add(match, 1.0);
        }
    }

    @Override
    public void add(Feature feature) {
        throw new UnsupportedOperationException("Use #add(feature, score) instead");
    }

    @Override
    public void addAll(Collection features) {
        throw new UnsupportedOperationException("Use #add(feature, score) instead");
    }

    public void add(int index, Feature feature) {
        throw new UnsupportedOperationException("Use #add(feature, score) instead");
    }

    @Override
    public Collection remove(Envelope envelope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(Collection features) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Feature feature) {
        throw new UnsupportedOperationException();
    }

    public void add(Feature feature, double score) {
        Assert.isTrue((0.0 <= score && score <= 1.0 ? 1 : 0) != 0, (String)("Score = " + score));
        if (score == 0.0) {
            return;
        }
        this.scores.add(new Double(score));
        this.dataset.add(feature);
        if (score > this.topScore) {
            this.topScore = score;
            this.topMatch = feature;
        }
    }

    public double getTopScore() {
        return this.topScore;
    }

    public Feature getTopMatch() {
        return this.topMatch;
    }

    public double getScore(int i) {
        return (Double)this.scores.get(i);
    }

    @Override
    public FeatureSchema getFeatureSchema() {
        return this.dataset.getFeatureSchema();
    }

    @Override
    public Envelope getEnvelope() {
        return this.dataset.getEnvelope();
    }

    @Override
    public int size() {
        return this.dataset.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dataset.isEmpty();
    }

    public Feature getFeature(int index) {
        return this.dataset.getFeature(index);
    }

    public List getFeatures() {
        return this.dataset.getFeatures();
    }

    @Override
    public Iterator iterator() {
        return this.dataset.iterator();
    }

    @Override
    public List query(Envelope envelope) {
        return this.dataset.query(envelope);
    }
}

