/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

class DisambiguationMatch
implements Comparable {
    private Feature target;
    private Feature candidate;
    private double score;

    public double getScore() {
        return this.score;
    }

    public Feature getCandidate() {
        return this.candidate;
    }

    public Feature getTarget() {
        return this.target;
    }

    public DisambiguationMatch(Feature target, Feature candidate, double score) {
        this.target = target;
        this.candidate = candidate;
        this.score = score;
    }

    public int compareTo(Object o) {
        DisambiguationMatch other = (DisambiguationMatch)o;
        if (this.score > other.score) {
            return -1;
        }
        if (this.score < other.score) {
            return 1;
        }
        if (this.target.compareTo(other.target) != 0) {
            return this.target.compareTo(other.target);
        }
        if (this.candidate.compareTo(other.candidate) != 0) {
            return this.candidate.compareTo(other.candidate);
        }
        Assert.shouldNeverReachHere((String)"Unexpected duplicate match?");
        return -1;
    }

    public static SortedSet createDisambiguationMatches(Map targetToMatchesMap, TaskMonitor monitor) {
        TreeSet<DisambiguationMatch> set = new TreeSet<DisambiguationMatch>();
        monitor.report("Sorting scores");
        int k = 0;
        for (Feature target : targetToMatchesMap.keySet()) {
            Matches matches = (Matches)targetToMatchesMap.get(target);
            monitor.report(++k, targetToMatchesMap.keySet().size(), "features");
            for (int j = 0; j < matches.size(); ++j) {
                set.add(new DisambiguationMatch(target, matches.getFeature(j), matches.getScore(j)));
            }
        }
        return set;
    }
}

