/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.AreaFilterFCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.DisambiguationMatch;
import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;

public class DisambiguatingFCMatchFinder
implements FCMatchFinder {
    private FCMatchFinder matchFinder;

    public DisambiguatingFCMatchFinder(FCMatchFinder matchFinder) {
        this.matchFinder = matchFinder;
    }

    @Override
    public Map match(FeatureCollection targetFC, FeatureCollection candidateFC, TaskMonitor monitor) {
        ArrayList<Feature> targets = new ArrayList<Feature>();
        ArrayList<Feature> candidates = new ArrayList<Feature>();
        ArrayList<Double> scores = new ArrayList<Double>();
        SortedSet matchSet = DisambiguationMatch.createDisambiguationMatches(this.matchFinder.match(targetFC, candidateFC, monitor), monitor);
        monitor.report("Discarding inferior matches");
        int j = 0;
        for (DisambiguationMatch match : matchSet) {
            monitor.report(++j, matchSet.size(), "matches");
            if (targets.contains(match.getTarget()) || candidates.contains(match.getCandidate())) continue;
            targets.add(match.getTarget());
            candidates.add(match.getCandidate());
            scores.add(new Double(match.getScore()));
        }
        Map targetToMatchesMap = AreaFilterFCMatchFinder.blankTargetToMatchesMap(targetFC.getFeatures(), candidateFC.getFeatureSchema());
        for (int i = 0; i < targets.size(); ++i) {
            Matches matches = new Matches(candidateFC.getFeatureSchema());
            matches.add((Feature)candidates.get(i), (Double)scores.get(i));
            targetToMatchesMap.put(targets.get(i), matches);
        }
        return targetToMatchesMap;
    }
}

