/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.FCMatchFinder;
import com.vividsolutions.jcs.conflate.polygonmatch.Matches;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AreaFilterFCMatchFinder
implements FCMatchFinder {
    private FCMatchFinder matchFinder;
    private double minArea;
    private double maxArea;

    public AreaFilterFCMatchFinder(double minArea, double maxArea, FCMatchFinder matchFinder) {
        Assert.isTrue((minArea < maxArea ? 1 : 0) != 0);
        this.minArea = minArea;
        this.maxArea = maxArea;
        this.matchFinder = matchFinder;
    }

    @Override
    public Map match(FeatureCollection targetFC, FeatureCollection candidateFC, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        Map filteredTargetToMatchesMap = this.matchFinder.match(this.filter(targetFC, "targets", monitor), this.filter(candidateFC, "candidates", monitor), monitor);
        Map targetToMatchesMap = AreaFilterFCMatchFinder.blankTargetToMatchesMap(targetFC.getFeatures(), candidateFC.getFeatureSchema());
        targetToMatchesMap.putAll(filteredTargetToMatchesMap);
        return targetToMatchesMap;
    }

    private IndexedFeatureCollection filter(FeatureCollection fc, String name, TaskMonitor monitor) {
        monitor.report("Filtering " + name + " by area");
        int featuresProcessed = 0;
        int totalFeatures = fc.size();
        FeatureDataset filteredFC = new FeatureDataset(fc.getFeatureSchema());
        Iterator i = fc.iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature feature = (Feature)i.next();
            monitor.report(++featuresProcessed, totalFeatures, "features");
            if (!this.satisfiesAreaCriterion(feature)) continue;
            filteredFC.add(feature);
        }
        return new IndexedFeatureCollection(filteredFC);
    }

    private boolean satisfiesAreaCriterion(Feature feature) {
        double area = feature.getGeometry().getArea();
        return this.minArea <= area && area <= this.maxArea;
    }

    public static Map blankTargetToMatchesMap(Collection targets, FeatureSchema matchesSchema) {
        HashMap<Feature, Matches> blankTargetToMatchesMap = new HashMap<Feature, Matches>();
        for (Feature target : targets) {
            blankTargetToMatchesMap.put(target, new Matches(matchesSchema));
        }
        return blankTargetToMatchesMap;
    }
}

