/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.Histogram;
import com.vividsolutions.jcs.conflate.polygonmatch.IndependentCandidateMatcher;
import com.vividsolutions.jcs.conflate.polygonmatch.MatcherUtil;
import com.vividsolutions.jcs.geom.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.List;

public class AngleHistogramMatcher
extends IndependentCandidateMatcher {
    private int binCount;

    public AngleHistogramMatcher() {
        this(18);
    }

    public AngleHistogramMatcher(int binCount) {
        this.binCount = binCount;
    }

    @Override
    public double match(Geometry target, Geometry candidate) {
        Histogram targetHist = this.angleHistogram(target, this.binCount);
        Histogram candidateHist = this.angleHistogram(candidate, this.binCount);
        return MatcherUtil.toScoreFromSymDiffArea(targetHist.getTotalScore(), candidateHist.getTotalScore(), targetHist.symDiff(candidateHist));
    }

    protected Histogram angleHistogram(Geometry g, int binCount) {
        Geometry clone = (Geometry)g.clone();
        clone.normalize();
        List lineStrings = CoordinateArrays.toCoordinateArrays(clone, false);
        Histogram h = new Histogram(binCount);
        for (Coordinate[] lineString : lineStrings) {
            h.add(this.angleHistogram(lineString, binCount));
        }
        return h;
    }

    private Histogram angleHistogram(Coordinate[] lineString, int binCount) {
        Histogram h = new Histogram(binCount);
        for (int i = 1; i < lineString.length; ++i) {
            h.addToBinScore(this.bin(Angle.angle(lineString[i - 1], lineString[i]), binCount), lineString[i - 1].distance(lineString[i]));
        }
        return h;
    }

    protected int bin(double angle, int binCount) {
        Assert.isTrue((angle >= -Math.PI ? 1 : 0) != 0);
        Assert.isTrue((angle <= Math.PI ? 1 : 0) != 0);
        double binSize = Math.PI * 2 / (double)binCount;
        int bin = (int)Math.floor((angle + Math.PI) / binSize);
        return Math.min(bin, binCount - 1);
    }

    public static void main(String[] args) throws Exception {
        String s = "POLYGON (( 138 314, 114 307, 89 293, 75 262, 71 219, 71 188, 75 146, 82 125, 110 122, 152 149, 194 184, 222 237, 225 275, 201 300, 159 317, 138 314 ))";
        Histogram h = new AngleHistogramMatcher().angleHistogram(new WKTReader().read(s), 18);
        for (int i = 0; i < h.getBinCount(); ++i) {
            System.out.println(h.getBinScore(i));
        }
    }
}

