/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jcs.conflate.polygonmatch;

import com.vividsolutions.jcs.conflate.polygonmatch.IndependentCandidateMatcher;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.Point2D;

public abstract class AbstractDistanceMatcher
extends IndependentCandidateMatcher {
    protected double maxDistance = 0.0;

    @Override
    public double match(Geometry target, Geometry candidate) {
        double distance = this.distance(target, candidate);
        if (this.maxDistance > 0.0) {
            return 1.0 - distance / this.maxDistance;
        }
        return 1.0 - distance / this.combinedEnvelopeDiagonalDistance(target, candidate);
    }

    protected abstract double distance(Geometry var1, Geometry var2);

    private double combinedEnvelopeDiagonalDistance(Geometry target, Geometry candidate) {
        Envelope envelope = new Envelope(target.getEnvelopeInternal());
        envelope.expandToInclude(candidate.getEnvelopeInternal());
        return Point2D.distance(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance < 0.0 ? 0.0 : maxDistance;
    }
}

