/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.Interval;
import java.util.Comparator;
import java.util.List;

public class SIRtree
extends AbstractSTRtree {
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return SIRtree.this.compareDoubles(((Interval)((Boundable)o1).getBounds()).getCentre(), ((Interval)((Boundable)o2).getBounds()).getCentre());
        }
    };
    private AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        public boolean intersects(Object aBounds, Object bBounds) {
            return ((Interval)aBounds).intersects((Interval)bBounds);
        }
    };

    public SIRtree() {
        this(10);
    }

    public SIRtree(int nodeCapacity) {
        super(nodeCapacity);
    }

    protected AbstractNode createNode(int level) {
        return new AbstractNode(level){

            protected Object computeBounds() {
                Interval bounds = null;
                for (Boundable childBoundable : this.getChildBoundables()) {
                    if (bounds == null) {
                        bounds = new Interval((Interval)childBoundable.getBounds());
                        continue;
                    }
                    bounds.expandToInclude((Interval)childBoundable.getBounds());
                }
                return bounds;
            }
        };
    }

    public void insert(double x1, double x2, Object item) {
        super.insert(new Interval(Math.min(x1, x2), Math.max(x1, x2)), item);
    }

    public List query(double x) {
        return this.query(x, x);
    }

    public List query(double x1, double x2) {
        return super.query(new Interval(Math.min(x1, x2), Math.max(x1, x2)));
    }

    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return this.intersectsOp;
    }

    protected Comparator getComparator() {
        return this.comparator;
    }
}

