/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;

public class GmlReader
extends AbstractReader
implements OdConstants {
    public static final String GML_FEATURE_MEMBER = "featureMember";
    public static final String GML_LINE_STRING = "LineString";
    public static final String GML_SRS_NAME = "srsName";
    public static final String GML_SRS_DIMENSION = "srsDimension";
    public static final String GML_POS_LIST = "posList";
    private XMLStreamReader parser;
    private Map<LatLon, Node> nodes = new HashMap<LatLon, Node>();

    public GmlReader(XMLStreamReader parser) {
        this.parser = parser;
    }

    public static DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in, (String)"UTF-8");
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
        return new GmlReader(parser).parseDoc();
    }

    private final boolean isElement(String element) {
        return this.parser.getLocalName().matches("(gml:)?" + element);
    }

    private DataSet parseDoc() throws XMLStreamException {
        DataSet ds = new DataSet();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.isElement(GML_FEATURE_MEMBER)) continue;
            this.parseFeatureMember(ds);
        }
        return ds;
    }

    private void parseFeatureMember(DataSet ds) throws XMLStreamException {
        ArrayList<Way> list = new ArrayList<Way>();
        Way way = null;
        Node node = null;
        String srs = null;
        int dim = -1;
        HashMap tags = new HashMap();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.isElement(GML_LINE_STRING)) {
                    way = new Way();
                    ds.addPrimitive((OsmPrimitive)way);
                    list.add(way);
                    srs = this.parser.getAttributeValue(null, GML_SRS_NAME);
                    dim = Integer.parseInt(this.parser.getAttributeValue(null, GML_SRS_DIMENSION));
                    continue;
                }
                if (!this.isElement(GML_POS_LIST)) continue;
                String[] stringArray = this.parser.getElementText().split(" ");
                for (int i = 0; i < stringArray.length; i += dim) {
                    LatLon ll = new LatLon(Double.valueOf(stringArray[0]).doubleValue(), Double.valueOf(stringArray[1]).doubleValue()).getRoundedToOsmPrecisionStrict();
                    node = this.nodes.get(ll);
                    if (node == null) {
                        node = new Node(ll);
                        ds.addPrimitive((OsmPrimitive)node);
                        this.nodes.put(ll, node);
                        if (dim > 2 && !stringArray[2].equals("0")) {
                            node.put("ele", stringArray[2]);
                        }
                    }
                    if (way == null) continue;
                    way.addNode(node);
                }
                continue;
            }
            if (event != 2 || !this.isElement(GML_FEATURE_MEMBER)) continue;
            break;
        }
        for (OsmPrimitive osmPrimitive : list) {
            for (String key : tags.keySet()) {
                osmPrimitive.put(key, (String)tags.get(key));
            }
        }
    }
}

