/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class WKTWriter {
    private int outputDimension = 2;
    private DecimalFormat formatter;
    private boolean isFormatted = false;
    private boolean useFormatting = false;
    private int coordsPerLine = -1;
    private String indentTabStr = "  ";

    public static String toLineString(CoordinateSequence coordinateSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LINESTRING ");
        if (coordinateSequence.size() == 0) {
            stringBuffer.append(" EMPTY");
        } else {
            stringBuffer.append("(");
            for (int i = 0; i < coordinateSequence.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(coordinateSequence.getX(i) + " " + coordinateSequence.getY(i));
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static String toLineString(Coordinate coordinate, Coordinate coordinate2) {
        return "LINESTRING ( " + coordinate.x + " " + coordinate.y + ", " + coordinate2.x + " " + coordinate2.y + " )";
    }

    private static DecimalFormat createFormatter(PrecisionModel precisionModel) {
        int n = precisionModel.getMaximumSignificantDigits();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        String string = "0" + (n > 0 ? "." : "") + WKTWriter.stringOfChar('#', n);
        return new DecimalFormat(string, decimalFormatSymbols);
    }

    public static String stringOfChar(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String write(Geometry geometry) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeFormatted(geometry, this.isFormatted, stringWriter);
        }
        catch (IOException iOException) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)stringWriter).toString();
    }

    private void writeFormatted(Geometry geometry, boolean bl, Writer writer) throws IOException {
        this.useFormatting = bl;
        this.formatter = WKTWriter.createFormatter(geometry.getPrecisionModel());
        this.appendGeometryTaggedText(geometry, 0, writer);
    }

    private void appendGeometryTaggedText(Geometry geometry, int n, Writer writer) throws IOException {
        this.indent(n, writer);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.appendPointTaggedText(point.getCoordinate(), writer);
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, n, writer);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, n, writer);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, n, writer);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, n, writer);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, n, writer);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, n, writer);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, n, writer);
        } else {
            Assert.shouldNeverReachHere("Unsupported Geometry implementation:" + geometry.getClass());
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, Writer writer) throws IOException {
        writer.write("POINT ");
        this.appendPointText(coordinate, writer);
    }

    private void appendLineStringTaggedText(LineString lineString, int n, Writer writer) throws IOException {
        writer.write("LINESTRING ");
        this.appendLineStringText(lineString, n, false, writer);
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, int n, Writer writer) throws IOException {
        writer.write("LINEARRING ");
        this.appendLineStringText(linearRing, n, false, writer);
    }

    private void appendPolygonTaggedText(Polygon polygon, int n, Writer writer) throws IOException {
        writer.write("POLYGON ");
        this.appendPolygonText(polygon, n, false, writer);
    }

    private void appendMultiPointTaggedText(MultiPoint multiPoint, int n, Writer writer) throws IOException {
        writer.write("MULTIPOINT ");
        this.appendMultiPointText(multiPoint, n, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, int n, Writer writer) throws IOException {
        writer.write("MULTILINESTRING ");
        this.appendMultiLineStringText(multiLineString, n, false, writer);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, int n, Writer writer) throws IOException {
        writer.write("MULTIPOLYGON ");
        this.appendMultiPolygonText(multiPolygon, n, writer);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, int n, Writer writer) throws IOException {
        writer.write("GEOMETRYCOLLECTION ");
        this.appendGeometryCollectionText(geometryCollection, n, writer);
    }

    private void appendPointText(Coordinate coordinate, Writer writer) throws IOException {
        if (coordinate == null) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendCoordinate(coordinate, writer);
            writer.write(")");
        }
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer) throws IOException {
        writer.write(this.writeNumber(coordinate.x) + " " + this.writeNumber(coordinate.y));
        if (this.outputDimension >= 3 && !Double.isNaN(coordinate.z)) {
            writer.write(" ");
            writer.write(this.writeNumber(coordinate.z));
        }
    }

    private String writeNumber(double d) {
        return this.formatter.format(d);
    }

    private void appendLineStringText(LineString lineString, int n, boolean bl, Writer writer) throws IOException {
        if (lineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (bl) {
                this.indent(n, writer);
            }
            writer.write("(");
            for (int i = 0; i < lineString.getNumPoints(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(n + 1, writer);
                    }
                }
                this.appendCoordinate(lineString.getCoordinateN(i), writer);
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(Polygon polygon, int n, boolean bl, Writer writer) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (bl) {
                this.indent(n, writer);
            }
            writer.write("(");
            this.appendLineStringText(polygon.getExteriorRing(), n, false, writer);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                writer.write(", ");
                this.appendLineStringText(polygon.getInteriorRingN(i), n + 1, true, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(MultiPoint multiPoint, int n, Writer writer) throws IOException {
        if (multiPoint.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    this.indentCoords(i, n + 1, writer);
                }
                writer.write("(");
                this.appendCoordinate(((Point)multiPoint.getGeometryN(i)).getCoordinate(), writer);
                writer.write(")");
            }
            writer.write(")");
        }
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, int n, boolean bl, Writer writer) throws IOException {
        if (multiLineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int n2 = n;
            boolean bl2 = bl;
            writer.write("(");
            for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    n2 = n + 1;
                    bl2 = true;
                }
                this.appendLineStringText((LineString)multiLineString.getGeometryN(i), n2, bl2, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, int n, Writer writer) throws IOException {
        if (multiPolygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int n2 = n;
            boolean bl = false;
            writer.write("(");
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    n2 = n + 1;
                    bl = true;
                }
                this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i), n2, bl, writer);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, int n, Writer writer) throws IOException {
        if (geometryCollection.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int n2 = n;
            writer.write("(");
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    n2 = n + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i), n2, writer);
            }
            writer.write(")");
        }
    }

    private void indentCoords(int n, int n2, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || n % this.coordsPerLine != 0) {
            return;
        }
        this.indent(n2, writer);
    }

    private void indent(int n, Writer writer) throws IOException {
        if (!this.useFormatting || n <= 0) {
            return;
        }
        writer.write("\n");
        for (int i = 0; i < n; ++i) {
            writer.write(this.indentTabStr);
        }
    }
}

