/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar
extends EdgeEndStar {
    private List resultAreaEdgeList;
    private Label label;
    private final int SCANNING_FOR_INCOMING = 1;
    private final int LINKING_TO_OUTGOING = 2;

    @Override
    public void insert(EdgeEnd edgeEnd) {
        DirectedEdge directedEdge = (DirectedEdge)edgeEnd;
        this.insertEdgeEnd(directedEdge, directedEdge);
    }

    public Label getLabel() {
        return this.label;
    }

    public int getOutgoingDegree(EdgeRing edgeRing) {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (directedEdge.getEdgeRing() != edgeRing) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void computeLabelling(GeometryGraph[] geometryGraphArray) {
        super.computeLabelling(geometryGraphArray);
        this.label = new Label(-1);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            Edge edge = edgeEnd.getEdge();
            Label label = edge.getLabel();
            for (int i = 0; i < 2; ++i) {
                int n = label.getLocation(i);
                if (n != 0 && n != 1) continue;
                this.label.setLocation(i, 0);
            }
        }
    }

    public void mergeSymLabels() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            Label label = directedEdge.getLabel();
            label.merge(directedEdge.getSym().getLabel());
        }
    }

    public void updateLabelling(Label label) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            Label label2 = directedEdge.getLabel();
            label2.setAllLocationsIfNull(0, label.getLocation(0));
            label2.setAllLocationsIfNull(1, label.getLocation(1));
        }
    }

    private List getResultAreaEdges() {
        if (this.resultAreaEdgeList != null) {
            return this.resultAreaEdgeList;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isInResult() && !directedEdge.getSym().isInResult()) continue;
            this.resultAreaEdgeList.add(directedEdge);
        }
        return this.resultAreaEdgeList;
    }

    public void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        int n = 1;
        block4: for (int i = 0; i < this.resultAreaEdgeList.size(); ++i) {
            DirectedEdge directedEdge3 = (DirectedEdge)this.resultAreaEdgeList.get(i);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            if (!directedEdge3.getLabel().isArea()) continue;
            if (directedEdge == null && directedEdge3.isInResult()) {
                directedEdge = directedEdge3;
            }
            switch (n) {
                case 1: {
                    if (!directedEdge4.isInResult()) continue block4;
                    directedEdge2 = directedEdge4;
                    n = 2;
                    continue block4;
                }
                case 2: {
                    if (!directedEdge3.isInResult()) continue block4;
                    directedEdge2.setNext(directedEdge3);
                    n = 1;
                }
            }
        }
        if (n == 2) {
            if (directedEdge == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert.isTrue(directedEdge.isInResult(), "unable to link last incoming dirEdge");
            directedEdge2.setNext(directedEdge);
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing edgeRing) {
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        int n = 1;
        block4: for (int i = this.resultAreaEdgeList.size() - 1; i >= 0; --i) {
            DirectedEdge directedEdge3 = (DirectedEdge)this.resultAreaEdgeList.get(i);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            if (directedEdge == null && directedEdge3.getEdgeRing() == edgeRing) {
                directedEdge = directedEdge3;
            }
            switch (n) {
                case 1: {
                    if (directedEdge4.getEdgeRing() != edgeRing) continue block4;
                    directedEdge2 = directedEdge4;
                    n = 2;
                    continue block4;
                }
                case 2: {
                    if (directedEdge3.getEdgeRing() != edgeRing) continue block4;
                    directedEdge2.setNextMin(directedEdge3);
                    n = 1;
                }
            }
        }
        if (n == 2) {
            Assert.isTrue(directedEdge != null, "found null for first outgoing dirEdge");
            Assert.isTrue(directedEdge.getEdgeRing() == edgeRing, "unable to link last incoming dirEdge");
            directedEdge2.setNextMin(directedEdge);
        }
    }

    public void findCoveredLineEdges() {
        DirectedEdge directedEdge;
        Object object;
        int n = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            object = (DirectedEdge)iterator.next();
            directedEdge = ((DirectedEdge)object).getSym();
            if (((DirectedEdge)object).isLineEdge()) continue;
            if (((DirectedEdge)object).isInResult()) {
                n = 0;
                break;
            }
            if (!directedEdge.isInResult()) continue;
            n = 2;
            break;
        }
        if (n == -1) {
            return;
        }
        int n2 = n;
        object = this.iterator();
        while (object.hasNext()) {
            directedEdge = (DirectedEdge)object.next();
            DirectedEdge directedEdge2 = directedEdge.getSym();
            if (directedEdge.isLineEdge()) {
                directedEdge.getEdge().setCovered(n2 == 0);
                continue;
            }
            if (directedEdge.isInResult()) {
                n2 = 2;
            }
            if (!directedEdge2.isInResult()) continue;
            n2 = 0;
        }
    }

    @Override
    public void print(PrintStream printStream) {
        System.out.println("DirectedEdgeStar: " + this.getCoordinate());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            printStream.print("out ");
            directedEdge.print(printStream);
            printStream.println();
            printStream.print("in ");
            directedEdge.getSym().print(printStream);
            printStream.println();
        }
    }
}

