/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.layers;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdLayer;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;

public class OdDiffLayer
extends Layer
implements OdLayer,
OdConstants {
    private final OdDataLayer dataLayer;
    public final List<Pair<OsmPrimitive, OsmPrimitive>> differentPrimitives;
    public final List<OsmPrimitive> onlyInTlsPrimitives;
    public final List<OsmPrimitive> onlyInOsmPrimitives;

    public OdDiffLayer(OdDataLayer dataLayer, String name) {
        super(name);
        this.dataLayer = dataLayer;
        this.differentPrimitives = new ArrayList<Pair<OsmPrimitive, OsmPrimitive>>();
        this.onlyInTlsPrimitives = new ArrayList<OsmPrimitive>();
        this.onlyInOsmPrimitives = new ArrayList<OsmPrimitive>();
        this.initDiff(dataLayer.data, dataLayer.osmLayer.data);
    }

    private void initDiff(DataSet tlsData, DataSet osmData) {
        for (OsmPrimitive p1 : tlsData.allPrimitives()) {
            if (!this.dataLayer.handler.isRelevant((IPrimitive)p1)) continue;
            OsmPrimitive p2 = this.findPrimitiveAt(osmData, p1);
            if (p2 == null) {
                this.onlyInTlsPrimitives.add(p1);
                continue;
            }
            if (this.dataLayer.handler.equals((IPrimitive)p1, (IPrimitive)p2)) continue;
            this.differentPrimitives.add((Pair<OsmPrimitive, OsmPrimitive>)new Pair((Object)p1, (Object)p2));
        }
        for (OsmPrimitive p1 : osmData.allPrimitives()) {
            if (!this.dataLayer.handler.isRelevant((IPrimitive)p1) || this.findPrimitiveAt(tlsData, p1) != null) continue;
            this.onlyInOsmPrimitives.add(p1);
        }
    }

    private double distance(OsmPrimitive p1, OsmPrimitive p2) {
        return p1.getBBox().getCenter().greatCircleDistance(p2.getBBox().getCenter());
    }

    private OsmPrimitive findPrimitiveAt(DataSet dataSet, OsmPrimitive source) {
        double maxDistance = Main.pref.getDouble("opendata.maxdistance", 10.0);
        OsmPrimitive nearestSamePrimitive = null;
        OsmPrimitive nearestPotentialPrimitive = null;
        for (OsmPrimitive p : dataSet.allPrimitives()) {
            double dist;
            if (!this.dataLayer.handler.isRelevant((IPrimitive)p) || !((dist = this.distance(source, p)) <= maxDistance)) continue;
            if (this.dataLayer.handler.equals((IPrimitive)p, (IPrimitive)source)) {
                if (nearestSamePrimitive != null && !(this.distance(p, nearestSamePrimitive) > dist)) continue;
                nearestSamePrimitive = p;
                continue;
            }
            if (nearestPotentialPrimitive != null && !(this.distance(p, nearestPotentialPrimitive) > dist)) continue;
            nearestPotentialPrimitive = p;
        }
        return nearestSamePrimitive != null ? nearestSamePrimitive : nearestPotentialPrimitive;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"diff");
    }

    public String getToolTipText() {
        return null;
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return null;
    }

    @Override
    public OdDataLayer getDataLayer() {
        return this.dataLayer;
    }
}

