/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.data.DataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpMathTransformException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ShpReader
extends AbstractReader
implements OdConstants {
    private final ShpHandler handler;
    private final CoordinateReferenceSystem wgs84;
    private final Map<String, Node> nodes;
    private CoordinateReferenceSystem crs;
    private MathTransform transform;
    private final Set<OsmPrimitive> featurePrimitives = new HashSet<OsmPrimitive>();

    public ShpReader(ShpHandler handler) throws NoSuchAuthorityCodeException, FactoryException {
        this.handler = handler;
        this.wgs84 = CRS.decode("EPSG:4326");
        this.nodes = new HashMap<String, Node>();
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new ShpReader(handler != null ? handler.getShpHandler() : null).parse(file, instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static final void compareDebug(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        Integer dim2;
        Integer dim1;
        System.out.println("-- COMPARING " + crs1.getName() + " WITH " + crs2.getName() + " --");
        ShpReader.compareDebug("class", crs1.getClass(), crs2.getClass());
        CoordinateSystem cs1 = crs1.getCoordinateSystem();
        CoordinateSystem cs2 = crs2.getCoordinateSystem();
        if (!ShpReader.compareDebug("cs", cs1, cs2) && ShpReader.compareDebug("cs.dim", dim1 = Integer.valueOf(cs1.getDimension()), dim2 = Integer.valueOf(cs2.getDimension()))) {
            for (int i = 0; i < dim1; ++i) {
                ShpReader.compareDebug("cs.axis" + i, cs1.getAxis(i), cs1.getAxis(i));
            }
        }
        if (crs1 instanceof AbstractSingleCRS) {
            Datum datum2;
            Datum datum1 = ((AbstractSingleCRS)crs1).getDatum();
            if (!ShpReader.compareDebug("datum", datum1, datum2 = ((AbstractSingleCRS)crs2).getDatum())) {
                AbstractIdentifiedObject adatum1 = (AbstractIdentifiedObject)((Object)datum1);
                AbstractIdentifiedObject adatum2 = (AbstractIdentifiedObject)((Object)datum2);
                ShpReader.compareDebug("datum.name1", adatum1.nameMatches(adatum2.getName().getCode()), adatum1.getName(), adatum2.getName());
                ShpReader.compareDebug("datum.name2", adatum2.nameMatches(adatum1.getName().getCode()), adatum2.getName(), adatum1.getName());
            }
            if (crs1 instanceof AbstractDerivedCRS) {
                AbstractDerivedCRS adcrs1 = (AbstractDerivedCRS)crs1;
                AbstractDerivedCRS adcrs2 = (AbstractDerivedCRS)crs2;
                ShpReader.compareDebug("baseCRS", adcrs1.getBaseCRS(), adcrs2.getBaseCRS());
                ShpReader.compareDebug("conversionFromBase", adcrs1.getConversionFromBase(), adcrs2.getConversionFromBase());
            }
        }
        System.out.println("-- COMPARING FINISHED --");
    }

    private static final boolean compareDebug(String text, Object o1, Object o2) {
        return ShpReader.compareDebug(text, o1.equals(o2), o1, o2);
    }

    private static final boolean compareDebug(String text, IdentifiedObject o1, IdentifiedObject o2) {
        return ShpReader.compareDebug(text, (AbstractIdentifiedObject)o1, (AbstractIdentifiedObject)o2);
    }

    private static final boolean compareDebug(String text, AbstractIdentifiedObject o1, AbstractIdentifiedObject o2) {
        return ShpReader.compareDebug(text, o1.equals(o2, false), o1, o2);
    }

    private static final boolean compareDebug(String text, boolean result, Object o1, Object o2) {
        System.out.println(text + ": " + result + "(" + o1 + ", " + o2 + ")");
        return result;
    }

    private void findCrsAndMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, Component parent) throws FactoryException, UserCancelException, ShpMathTransformException {
        block13: {
            this.crs = coordinateReferenceSystem;
            try {
                this.transform = CRS.findMathTransform(this.crs, this.wgs84);
            }
            catch (OperationNotFoundException e) {
                System.out.println(this.crs.getName() + ": " + e.getMessage());
                ArrayList<CoordinateReferenceSystem> candidates = new ArrayList<CoordinateReferenceSystem>();
                for (String code : CRS.getAuthorityFactory(false).getAuthorityCodes(ProjectedCRS.class)) {
                    CoordinateReferenceSystem candidate = CRS.decode(code);
                    if (!(candidate instanceof AbstractCRS) || !(this.crs instanceof AbstractIdentifiedObject)) continue;
                    Hints.putSystemDefault(Hints.COMPARISON_TOLERANCE, Main.pref.getDouble("opendata.crs.comparison_tolerance", DEFAULT_CRS_COMPARISON_TOLERANCE.doubleValue()));
                    if (((AbstractCRS)candidate).equals((AbstractIdentifiedObject)((Object)this.crs), false)) {
                        System.out.println("Found a potential CRS: " + candidate.getName());
                        candidates.add(candidate);
                    } else if (Main.pref.getBoolean("opendata.crs.comparison_debug", false)) {
                        ShpReader.compareDebug(this.crs, candidate);
                    }
                    Hints.removeSystemDefault(Hints.COMPARISON_TOLERANCE);
                }
                if (candidates.size() > 1) {
                    System.err.println("Found several potential CRS.");
                }
                if (candidates.size() > 0) {
                    CoordinateReferenceSystem newCRS = (CoordinateReferenceSystem)candidates.get(0);
                    try {
                        this.transform = CRS.findMathTransform(newCRS, this.wgs84, false);
                    }
                    catch (OperationNotFoundException ex) {
                        System.err.println(newCRS.getName() + ": " + e.getMessage());
                    }
                }
                if (this.transform != null) break block13;
                if (this.handler != null) {
                    this.transform = this.handler.findMathTransform(this.crs, this.wgs84, false);
                }
                if (this.transform != null) break block13;
                if (ShpReader.warnLenientMethod(parent, this.crs)) {
                    throw new UserCancelException();
                }
                System.out.println("Searching for a lenient math transform.");
                this.transform = CRS.findMathTransform(this.crs, this.wgs84, true);
            }
        }
        if (this.transform == null) {
            throw new ShpMathTransformException("Unable to find math transform !");
        }
    }

    private void parseFeature(Feature feature, Component parent) throws UserCancelException, ShpMathTransformException, FactoryException, ShpCrsException, MismatchedDimensionException, TransformException {
        this.featurePrimitives.clear();
        GeometryAttribute geometry = feature.getDefaultGeometryProperty();
        if (geometry != null) {
            GeometryDescriptor desc = geometry.getDescriptor();
            if (this.crs == null && desc != null && desc.getCoordinateReferenceSystem() != null) {
                this.findCrsAndMathTransform(desc.getCoordinateReferenceSystem(), parent);
            } else if (this.crs == null) {
                throw new ShpCrsException("Unable to detect CRS !");
            }
            Node primitive = null;
            if (geometry.getValue() instanceof Point) {
                primitive = this.createOrGetNode((Point)geometry.getValue());
            } else if (geometry.getValue() instanceof GeometryCollection) {
                GeometryCollection mp = (GeometryCollection)geometry.getValue();
                int nGeometries = mp.getNumGeometries();
                if (nGeometries < 1) {
                    System.err.println("Error: empty geometry collection found");
                } else {
                    Way r = null;
                    Way w = null;
                    for (int i = 0; i < nGeometries; ++i) {
                        Geometry g = mp.getGeometryN(i);
                        if (g instanceof Polygon) {
                            Polygon p = (Polygon)g;
                            if (r == null && (nGeometries > 1 || p.getNumInteriorRing() > 0 || this.handler != null && this.handler.preferMultipolygonToSimpleWay())) {
                                r = this.createMultipolygon();
                            }
                            w = this.createWay(p.getExteriorRing());
                            if (r == null) continue;
                            this.addWayToMp((Relation)r, "outer", w);
                            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                                this.addWayToMp((Relation)r, "inner", this.createWay(p.getInteriorRingN(j)));
                            }
                            continue;
                        }
                        if (g instanceof LineString) {
                            w = this.createWay((LineString)g);
                            continue;
                        }
                        if (g instanceof Point) {
                            ShpReader.readNonGeometricAttributes(feature, (OsmPrimitive)this.createOrGetNode((Point)g));
                            continue;
                        }
                        System.err.println("Error: unsupported geometry : " + g);
                    }
                    primitive = r != null ? r : w;
                }
            } else {
                System.out.println("\ttype: " + geometry.getType());
                System.out.println("\tbounds: " + geometry.getBounds());
                System.out.println("\tdescriptor: " + desc);
                System.out.println("\tname: " + geometry.getName());
                System.out.println("\tvalue: " + geometry.getValue());
                System.out.println("\tid: " + geometry.getIdentifier());
                System.out.println("-------------------------------------------------------------");
            }
            if (primitive != null) {
                ShpReader.readNonGeometricAttributes(feature, (OsmPrimitive)primitive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet parse(File file, ProgressMonitor instance) throws IOException {
        this.crs = null;
        this.transform = null;
        try {
            DataStore dataStore;
            if (file == null) return this.ds;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            if (this.handler != null && this.handler.getDbfCharset() != null) {
                params.put(ShapefileDataStoreFactory.DBFCHARSET.key, this.handler.getDbfCharset());
            }
            if ((dataStore = new ShapefileDataStoreFactory().createDataStore(params)) == null) {
                throw new IOException(I18n.tr((String)"Unable to find a data store for file {0}", (Object[])new Object[]{file.getName()}));
            }
            String[] typeNames = dataStore.getTypeNames();
            String typeName = typeNames[0];
            SimpleFeatureSource featureSource = dataStore.getFeatureSource(typeName);
            FeatureCollection collection = featureSource.getFeatures();
            FeatureIterator iterator = collection.features();
            if (instance != null) {
                instance.beginTask(I18n.tr((String)"Loading shapefile ({0} features)", (Object[])new Object[]{collection.size()}), collection.size());
            }
            int n = 0;
            Component parent = instance != null ? instance.getWindowParent() : Main.parent;
            try {
                while (iterator.hasNext()) {
                    ++n;
                    try {
                        Object feature = iterator.next();
                        this.parseFeature((Feature)iterator.next(), parent);
                        if (this.handler != null) {
                            this.handler.notifyFeatureParsed(feature, this.ds, this.featurePrimitives);
                        }
                    }
                    catch (UserCancelException e) {
                        DataSet dataSet = this.ds;
                        iterator.close();
                        this.nodes.clear();
                        if (instance == null) return dataSet;
                        instance.setCustomText(null);
                        return dataSet;
                    }
                    if (instance == null) continue;
                    instance.worked(1);
                    instance.setCustomText(n + "/" + collection.size());
                }
                return this.ds;
            }
            finally {
                iterator.close();
                this.nodes.clear();
                if (instance != null) {
                    instance.setCustomText(null);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static final boolean warnLenientMethod(Component parent, CoordinateReferenceSystem crs) {
        ExtendedDialog dlg = new ExtendedDialog(parent, I18n.tr((String)"Cannot transform to WGS84", (Object[])new Object[0]), new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Continue", (Object[])new Object[0])});
        dlg.setContent("<html>" + I18n.tr((String)"JOSM was unable to find a strict mathematical transformation between ''{0}'' and WGS84.<br /><br />Do you want to try a <i>lenient</i> method, which will perform a non-precise transformation (<b>with location errors up to 1 km</b>) ?<br/><br/>If so, <b>do NOT upload</b> such data to OSM !", (Object[])new Object[]{crs.getName()}) + "</html>");
        dlg.setButtonIcons(new Icon[]{ImageProvider.get((String)"cancel"), ImageProvider.overlay((Icon)ImageProvider.get((String)"ok"), (Icon)new ImageIcon(ImageProvider.get((String)"warning-small").getImage().getScaledInstance(10, 10, 4)), (ImageProvider.OverlayPosition)ImageProvider.OverlayPosition.SOUTHEAST)});
        dlg.setToolTipTexts(new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Try lenient method", (Object[])new Object[0])});
        dlg.setIcon(2);
        dlg.setCancelButton(new Integer[]{1});
        return dlg.showDialog().getValue() != 2;
    }

    private static final void readNonGeometricAttributes(Feature feature, OsmPrimitive primitive) {
        for (Property prop : feature.getProperties()) {
            if (prop instanceof GeometryAttribute) continue;
            Name name = prop.getName();
            Object value = prop.getValue();
            if (name == null || value == null) continue;
            String sName = ((Object)name).toString();
            String sValue = value.toString();
            if (sName.isEmpty() || sValue.isEmpty()) continue;
            primitive.put(sName, sValue);
        }
    }

    private Node getNode(Point p, String key) {
        Node n = this.nodes.get(key);
        if (n == null && this.handler != null && this.handler.checkNodeProximity()) {
            LatLon ll = new LatLon(p.getY(), p.getX());
            for (Node node : this.nodes.values()) {
                if (!node.getCoor().equalsEpsilon(ll)) continue;
                return node;
            }
        }
        return n;
    }

    private Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        String key;
        Point p2 = (Point)JTS.transform(p, this.transform);
        Node n = this.getNode(p2, key = p2.getX() + "/" + p2.getY());
        if (n == null) {
            n = new Node(new LatLon(p2.getY(), p2.getX()));
            if (this.handler == null || this.handler.useNodeMap()) {
                this.nodes.put(key, n);
            }
            this.ds.addPrimitive((OsmPrimitive)n);
        } else if (n.getDataSet() == null) {
            this.ds.addPrimitive((OsmPrimitive)n);
        }
        this.featurePrimitives.add((OsmPrimitive)n);
        return n;
    }

    private Way createWay(LineString ls) {
        Way w = new Way();
        if (ls != null) {
            for (int i = 0; i < ls.getNumPoints(); ++i) {
                try {
                    w.addNode(this.createOrGetNode(ls.getPointN(i)));
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        return this.addOsmPrimitive(w);
    }

    private Relation createMultipolygon() {
        Relation r = new Relation();
        r.put("type", "multipolygon");
        return this.addOsmPrimitive(r);
    }

    private void addWayToMp(Relation r, String role, Way w) {
        r.addMember(new RelationMember(role, (OsmPrimitive)w));
    }

    private <T extends OsmPrimitive> T addOsmPrimitive(T p) {
        this.ds.addPrimitive(p);
        this.featurePrimitives.add(p);
        return p;
    }
}

