/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.LambertConformal2SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.tools.Pair;

public class DefaultShpHandler
implements ShpHandler,
OdConstants {
    private static final List<Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>> ellipsoids = new ArrayList<Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>>();
    private boolean useNodeMap = true;
    private boolean checkNodeProximity = false;
    private boolean preferMultipolygonToSimpleWay = false;
    private Charset dbfCharset = null;

    protected static final Double get(ParameterValueGroup values, ParameterDescriptor desc) {
        return (Double)values.parameter(desc.getName().getCode()).getValue();
    }

    private static final boolean equals(Double a, Double b) {
        boolean res;
        boolean bl = res = Math.abs(a - b) <= Main.pref.getDouble("opendata.crs.comparison_tolerance", DEFAULT_CRS_COMPARISON_TOLERANCE.doubleValue());
        if (Main.pref.getBoolean("opendata.crs.comparison_debug", false)) {
            System.out.println("Comparing " + a + " and " + b + " -> " + res);
        }
        return res;
    }

    @Override
    public MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (sourceCRS instanceof GeographicCRS && sourceCRS.getName().getCode().equalsIgnoreCase("GCS_ETRS_1989")) {
            return CRS.findMathTransform(CRS.decode("EPSG:4258"), targetCRS, lenient);
        }
        if (sourceCRS instanceof AbstractDerivedCRS && sourceCRS.getName().getCode().equalsIgnoreCase("Lambert_Conformal_Conic")) {
            ArrayList<MathTransform> result = new ArrayList<MathTransform>();
            AbstractDerivedCRS crs = (AbstractDerivedCRS)sourceCRS;
            MathTransform transform = crs.getConversionFromBase().getMathTransform();
            if (transform instanceof LambertConformal && crs.getDatum() instanceof GeodeticDatum) {
                LambertConformal lambert = (LambertConformal)transform;
                GeodeticDatum geo = (GeodeticDatum)crs.getDatum();
                for (Projection p : Projections.getProjections()) {
                    AbstractProjection ap;
                    if (!(p instanceof AbstractProjection) || !((ap = (AbstractProjection)p).getProj() instanceof LambertConformalConic)) continue;
                    for (Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid> pair : ellipsoids) {
                        if (!((Ellipsoid)pair.a).equals(geo.getEllipsoid()) || !((org.openstreetmap.josm.data.projection.Ellipsoid)pair.b).equals(ap.getEllipsoid())) continue;
                        boolean ok = true;
                        ParameterValueGroup values = lambert.getParameterValues();
                        LambertConformalConic.Parameters params = ((LambertConformalConic)ap.getProj()).getParameters();
                        ok = ok ? DefaultShpHandler.equals(DefaultShpHandler.get(values, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN), params.latitudeOrigin) : ok;
                        ok = ok ? DefaultShpHandler.equals(DefaultShpHandler.get(values, MapProjection.AbstractProvider.CENTRAL_MERIDIAN), ap.getCentralMeridian()) : ok;
                        ok = ok ? DefaultShpHandler.equals(DefaultShpHandler.get(values, MapProjection.AbstractProvider.SCALE_FACTOR), ap.getScaleFactor()) : ok;
                        ok = ok ? DefaultShpHandler.equals(DefaultShpHandler.get(values, MapProjection.AbstractProvider.FALSE_EASTING), ap.getFalseEasting()) : ok;
                        boolean bl = ok = ok ? DefaultShpHandler.equals(DefaultShpHandler.get(values, MapProjection.AbstractProvider.FALSE_NORTHING), ap.getFalseNorthing()) : ok;
                        if (lambert instanceof LambertConformal2SP && params instanceof LambertConformalConic.Parameters2SP) {
                            LambertConformalConic.Parameters2SP param = (LambertConformalConic.Parameters2SP)params;
                            ok = ok ? DefaultShpHandler.equals(Math.min(DefaultShpHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_1), DefaultShpHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_2)), Math.min(param.standardParallel1, param.standardParallel2)) : ok;
                            ok = ok ? DefaultShpHandler.equals(Math.max(DefaultShpHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_1), DefaultShpHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_2)), Math.max(param.standardParallel1, param.standardParallel2)) : ok;
                        } else if (!(lambert instanceof LambertConformal1SP) || !(params instanceof LambertConformalConic.Parameters1SP)) {
                            ok = false;
                        }
                        if (!ok) continue;
                        try {
                            result.add(CRS.findMathTransform(CRS.decode(p.toCode()), targetCRS, lenient));
                        }
                        catch (FactoryException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                }
            }
            if (!result.isEmpty()) {
                if (result.size() > 1) {
                    System.err.println("Found multiple projections !");
                }
                return (MathTransform)result.get(0);
            }
        }
        return null;
    }

    @Override
    public boolean preferMultipolygonToSimpleWay() {
        return this.preferMultipolygonToSimpleWay;
    }

    @Override
    public void setPreferMultipolygonToSimpleWay(boolean prefer) {
        this.preferMultipolygonToSimpleWay = prefer;
    }

    @Override
    public boolean checkNodeProximity() {
        return this.checkNodeProximity;
    }

    @Override
    public void setCheckNodeProximity(boolean check) {
        this.checkNodeProximity = check;
    }

    @Override
    public void setUseNodeMap(boolean use) {
        this.useNodeMap = use;
    }

    @Override
    public boolean useNodeMap() {
        return this.useNodeMap;
    }

    @Override
    public void notifyFeatureParsed(Object feature, DataSet result, Set<OsmPrimitive> featurePrimitives) {
    }

    @Override
    public void setDbfCharset(Charset charset) {
        this.dbfCharset = charset;
    }

    @Override
    public Charset getDbfCharset() {
        return this.dbfCharset;
    }

    static {
        ellipsoids.add((Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>)new Pair((Object)DefaultEllipsoid.GRS80, (Object)org.openstreetmap.josm.data.projection.Ellipsoid.GRS80));
        ellipsoids.add((Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>)new Pair((Object)DefaultEllipsoid.WGS84, (Object)org.openstreetmap.josm.data.projection.Ellipsoid.WGS84));
    }
}

