/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets.fr;

import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.LambertConformal2SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.DefaultShpHandler;

public class FrenchShpHandler
extends DefaultShpHandler {
    @Override
    public MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        GeodeticDatum datum;
        if (sourceCRS.getName().getCode().equalsIgnoreCase("RGM04")) {
            return CRS.findMathTransform(CRS.decode("EPSG:4471"), targetCRS, lenient);
        }
        if (sourceCRS.getName().getCode().equalsIgnoreCase("RGFG95_UTM_Zone_22N")) {
            return CRS.findMathTransform(CRS.decode("EPSG:2972"), targetCRS, lenient);
        }
        if (sourceCRS.getName().getCode().equalsIgnoreCase("Lambert I Nord") && sourceCRS instanceof ProjectedCRS && (datum = ((ProjectedCRS)sourceCRS).getDatum()).getPrimeMeridian().getGreenwichLongitude() > 0.0 && ((ProjectedCRS)sourceCRS).getConversionFromBase().getMathTransform() instanceof LambertConformal2SP) {
            LambertConformal2SP lambert = (LambertConformal2SP)((ProjectedCRS)sourceCRS).getConversionFromBase().getMathTransform();
            Double falseNorthing = FrenchShpHandler.get(lambert.getParameterValues(), MapProjection.AbstractProvider.FALSE_NORTHING);
            Double centralmeridian = FrenchShpHandler.get(lambert.getParameterValues(), MapProjection.AbstractProvider.CENTRAL_MERIDIAN);
            if (centralmeridian.equals(0.0)) {
                if (falseNorthing.equals(200000.0)) {
                    return CRS.findMathTransform(CRS.decode("EPSG:27561"), targetCRS, lenient);
                }
                if (falseNorthing.equals(1200000.0)) {
                    return CRS.findMathTransform(CRS.decode("EPSG:27571"), targetCRS, lenient);
                }
            }
        }
        return super.findMathTransform(sourceCRS, targetCRS, lenient);
    }
}

