/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetCategory;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.DefaultZipHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.DefaultShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultCsvHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.core.util.NamesFrUtils;
import org.openstreetmap.josm.tools.Pair;

public abstract class AbstractDataSetHandler
implements OdConstants {
    private String name;
    private DataSetCategory category;
    private String sourceDate;
    private File associatedFile;
    private License license;
    private URL dataURL;
    private URL wikiURL;
    private URL localPortalURL;
    private URL nationalPortalURL;
    private boolean hasLicenseToBeAccepted = true;
    private ShpHandler shpHandler;
    private ZipHandler zipHandler;
    private SpreadSheetHandler ssHandler;

    public abstract boolean acceptsFilename(String var1);

    public boolean acceptsFile(File file) {
        return this.acceptsFilename(file.getName());
    }

    public abstract void updateDataSet(DataSet var1);

    public void checkDataSetSource(DataSet ds) {
        if (ds != null) {
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (!p.hasKeys() && !p.getReferrers().isEmpty()) continue;
                if (this.getSource() != null && p.get("source") == null) {
                    p.put("source", this.getSource());
                }
                if (this.sourceDate == null || p.get("source:date") != null) continue;
                p.put("source:date", this.sourceDate);
            }
        }
    }

    public void checkNames(DataSet ds) {
        if (ds != null) {
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (p.get("name") == null) continue;
                p.put("name", NamesFrUtils.checkDictionary(p.get("name")));
            }
        }
    }

    public AbstractDataSetHandler() {
        this.setShpHandler(new DefaultShpHandler());
        this.setZipHandler(new DefaultZipHandler());
        this.setCsvHandler(new DefaultCsvHandler());
    }

    private final boolean acceptsFilename(String filename, String[] expected, String ... extensions) {
        if (filename != null) {
            for (String name : expected) {
                for (String ext : extensions) {
                    if (!Pattern.compile(name + "\\." + ext, 2).matcher(filename).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected final boolean acceptsCsvFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv");
    }

    protected final boolean acceptsXlsFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "xls");
    }

    protected final boolean acceptsOdsFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "ods");
    }

    protected final boolean acceptsShpFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "shp");
    }

    protected final boolean acceptsMifFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "mif");
    }

    protected final boolean acceptsMifTabFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "mif", "tab");
    }

    protected final boolean acceptsShpMifFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "shp", "mif");
    }

    protected final boolean acceptsKmlFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kml");
    }

    protected final boolean acceptsKmzFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kmz");
    }

    protected final boolean acceptsKmzShpFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kmz", "shp");
    }

    protected final boolean acceptsKmzTabFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kmz", "tab");
    }

    protected final boolean acceptsZipFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "zip");
    }

    protected final boolean acceptsCsvKmzFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv", "kmz");
    }

    protected final boolean acceptsCsvKmzTabFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv", "kmz", "tab");
    }

    protected final boolean acceptsCsvXlsFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv", "xls");
    }

    public License getLicense() {
        return this.license;
    }

    public final void setLicense(License license) {
        this.license = license;
    }

    public URL getDataURL() {
        return this.dataURL;
    }

    public final void setDataURL(URL dataURL) {
        this.dataURL = dataURL;
    }

    public final void setDataURL(String dataURL) throws MalformedURLException {
        this.setDataURL(new URL(dataURL));
    }

    public URL getWikiURL() {
        return this.wikiURL;
    }

    public final void setWikiURL(URL wikiURL) {
        this.wikiURL = wikiURL;
    }

    public final void setWikiURL(String wikiURL) throws MalformedURLException {
        this.setWikiURL(new URL(wikiURL));
    }

    public URL getLocalPortalURL() {
        return this.localPortalURL;
    }

    public final void setLocalPortalURL(URL localPortalURL) {
        this.localPortalURL = localPortalURL;
    }

    public final void setLocalPortalURL(String localPortalURL) throws MalformedURLException {
        this.setLocalPortalURL(new URL(localPortalURL));
    }

    public URL getNationalPortalURL() {
        return this.nationalPortalURL;
    }

    public final void setNationalPortalURL(URL nationalPortalURL) {
        this.nationalPortalURL = nationalPortalURL;
    }

    public final void setNationalPortalURL(String nationalPortalURL) throws MalformedURLException {
        this.setNationalPortalURL(new URL(nationalPortalURL));
    }

    public List<Pair<String, URL>> getDataURLs() {
        return null;
    }

    public AbstractReader getReaderForUrl(String url) {
        return null;
    }

    public final boolean hasLicenseToBeAccepted() {
        return this.hasLicenseToBeAccepted;
    }

    public final void setHasLicenseToBeAccepted(boolean hasLicenseToBeAccepted) {
        this.hasLicenseToBeAccepted = hasLicenseToBeAccepted;
    }

    public final DataSetCategory getCategory() {
        return this.category;
    }

    public final void setCategory(DataSetCategory category) {
        this.category = category;
    }

    public final Collection<String> getOsmXapiRequests(Bounds bounds) {
        return this.getOsmXapiRequests(LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lon()) + "," + LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lat()) + "," + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lon()) + "," + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lat()));
    }

    protected Collection<String> getOsmXapiRequests(String bbox) {
        return null;
    }

    public final String getOverpassApiRequest(Bounds bounds) {
        return this.getOverpassApiRequest("w=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lon()) + "\" " + "s=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lat()) + "\" " + "e=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lon()) + "\" " + "n=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lat()) + "\"");
    }

    protected String getOverpassApiRequest(String bbox) {
        return null;
    }

    public boolean equals(IPrimitive p1, IPrimitive p2) {
        return false;
    }

    public boolean isRelevant(IPrimitive p) {
        return false;
    }

    public final Collection<IPrimitive> extractRelevantPrimitives(DataSet ds) {
        ArrayList<IPrimitive> result = new ArrayList<IPrimitive>();
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (!this.isRelevant((IPrimitive)p)) continue;
            result.add((IPrimitive)p);
        }
        return result;
    }

    public boolean isForbidden(IPrimitive p) {
        return false;
    }

    public boolean hasForbiddenTags() {
        return false;
    }

    protected final void replace(IPrimitive p, String dataKey, String osmKey) {
        this.addOrReplace(p, dataKey, osmKey, null, null, null, true);
    }

    protected final void replace(IPrimitive p, String dataKey, String osmKey, ValueReplacer replacer) {
        this.addOrReplace(p, dataKey, osmKey, null, null, replacer, true);
    }

    protected final void replace(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues) {
        this.addOrReplace(p, dataKey, osmKey, dataValues, osmValues, null, true);
    }

    protected final void add(IPrimitive p, String dataKey, String osmKey, ValueReplacer replacer) {
        this.addOrReplace(p, dataKey, osmKey, null, null, replacer, false);
    }

    protected final void add(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues) {
        this.addOrReplace(p, dataKey, osmKey, dataValues, osmValues, null, false);
    }

    private final void addOrReplace(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues, ValueReplacer replacer, boolean replace) {
        String value = p.get(dataKey);
        if (value != null) {
            int index = -1;
            for (int i = 0; dataValues != null && index == -1 && i < dataValues.length; ++i) {
                if (!Pattern.compile(dataValues[i], 2).matcher(value).matches()) continue;
                index = i;
            }
            if (index > -1 && osmValues != null) {
                this.doAddReplace(p, dataKey, osmKey, osmValues[index], replace);
            } else if (replacer != null) {
                this.doAddReplace(p, dataKey, osmKey, replacer.replace(value), replace);
            } else if (dataValues == null || osmValues == null) {
                this.doAddReplace(p, dataKey, osmKey, value, replace);
            }
        }
    }

    private final void doAddReplace(IPrimitive p, String dataKey, String osmKey, String osmValue, boolean replace) {
        if (replace) {
            p.remove(dataKey);
        }
        p.put(osmKey, osmValue);
    }

    public String getSource() {
        return null;
    }

    public final String getSourceDate() {
        return this.sourceDate;
    }

    public final void setSourceDate(String sourceDate) {
        this.sourceDate = sourceDate;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getLocalPortalIconName() {
        return "o24.png";
    }

    public String getNationalPortalIconName() {
        return "o24.png";
    }

    public String getDataLayerIconName() {
        return "o16.png";
    }

    public SourceEditor.ExtendedSourceEntry getMapPaintStyle() {
        return null;
    }

    public SourceEditor.ExtendedSourceEntry getTaggingPreset() {
        return null;
    }

    protected final SourceEditor.ExtendedSourceEntry getMapPaintStyle(String displayName) {
        return this.getMapPaintStyle(displayName, this.getClass().getSimpleName().replace("Handler", ""));
    }

    protected final SourceEditor.ExtendedSourceEntry getMapPaintStyle(String displayName, String fileNameWithoutExtension) {
        return new SourceEditor.ExtendedSourceEntry(displayName, "resource://" + this.getClass().getPackage().getName().replace(".", "/") + "/" + fileNameWithoutExtension + "." + "mapcss");
    }

    public final void setAssociatedFile(File associatedFile) {
        this.associatedFile = associatedFile;
    }

    public final File getAssociatedFile() {
        return this.associatedFile;
    }

    public boolean acceptsUrl(String url) {
        if (this.getDataURL() != null && url.equals(this.getDataURL().toString())) {
            return true;
        }
        if (this.getDataURLs() != null) {
            for (Pair<String, URL> pair : this.getDataURLs()) {
                if (pair.b == null || !url.equals(((URL)pair.b).toString())) continue;
                return true;
            }
        }
        return false;
    }

    public final void setShpHandler(ShpHandler handler) {
        this.shpHandler = handler;
    }

    public final ShpHandler getShpHandler() {
        return this.shpHandler;
    }

    public final void setZipHandler(ZipHandler handler) {
        this.zipHandler = handler;
    }

    public ZipHandler getZipHandler() {
        return this.zipHandler;
    }

    public final void setSpreadSheetHandler(SpreadSheetHandler handler) {
        this.ssHandler = handler;
    }

    public final SpreadSheetHandler getSpreadSheetHandler() {
        return this.ssHandler;
    }

    public final void setCsvHandler(CsvHandler handler) {
        this.setSpreadSheetHandler(handler);
    }

    public final CsvHandler getCsvHandler() {
        if (this.ssHandler instanceof CsvHandler) {
            return (CsvHandler)this.ssHandler;
        }
        return null;
    }

    public static interface ValueReplacer {
        public String replace(String var1);
    }
}

