/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.geotools.resources.i18n.Errors;

public final class Classes {
    public static final byte DOUBLE = 8;
    public static final byte FLOAT = 7;
    public static final byte LONG = 6;
    public static final byte INTEGER = 5;
    public static final byte SHORT = 4;
    public static final byte BYTE = 3;
    public static final byte CHARACTER = 2;
    public static final byte BOOLEAN = 1;
    public static final byte OTHER = 0;
    private static final Map<Class<?>, Classes> MAPPING = new HashMap(16);
    private final Class<?> wrapper;
    private final boolean isInteger;

    private Classes(Class<?> primitive, Class<?> wrapper, boolean isFloat, boolean isInteger, byte size, byte ordinal) {
        this.wrapper = wrapper;
        this.isInteger = isInteger;
        if (MAPPING.put(primitive, this) != null || MAPPING.put(wrapper, this) != null) {
            throw new AssertionError();
        }
    }

    public static Class<?> boundOfParameterizedAttribute(Method method) {
        Type[] parameters;
        Class<?> c = Classes.getActualTypeArgument(method.getGenericReturnType());
        if (c == null && (parameters = method.getGenericParameterTypes()) != null && parameters.length == 1) {
            c = Classes.getActualTypeArgument(parameters[0]);
        }
        return c;
    }

    private static Class<?> getActualTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] p = ((ParameterizedType)type).getActualTypeArguments();
            while (p != null && p.length == 1) {
                type = p[0];
                if (type instanceof Class) {
                    return (Class)type;
                }
                if (!(type instanceof WildcardType)) break;
                p = ((WildcardType)type).getUpperBounds();
            }
        }
        return null;
    }

    public static <T> Class<? extends T> getClass(T object) {
        return object != null ? object.getClass() : null;
    }

    public static <T> boolean sameInterfaces(Class<? extends T> object1, Class<? extends T> object2, Class<T> base) {
        Class<?> c;
        int i;
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = object1.getInterfaces();
        Class<?>[] c2 = object2.getInterfaces();
        int n = 0;
        for (i = 0; i < c2.length; ++i) {
            c = c2[i];
            if (!base.isAssignableFrom(c)) continue;
            c2[n++] = c;
        }
        block1: for (i = 0; i < c1.length; ++i) {
            c = c1[i];
            if (!base.isAssignableFrom(c)) continue;
            for (int j = 0; j < n; ++j) {
                if (!c.equals(c2[j])) continue;
                System.arraycopy(c2, j + 1, c2, j, --n - j);
                continue block1;
            }
            return false;
        }
        return n == 0;
    }

    public static boolean isInteger(Class<?> type) {
        Classes mapping = MAPPING.get(type);
        return mapping != null && mapping.isInteger;
    }

    public static Class<?> primitiveToWrapper(Class<?> type) {
        Classes mapping = MAPPING.get(type);
        return mapping != null ? mapping.wrapper : type;
    }

    public static <T> T valueOf(Class<T> type, String value) throws IllegalArgumentException, NumberFormatException {
        if (value == null) {
            return null;
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(value);
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(value);
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(value);
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(value);
        }
        if (Short.class.equals(type)) {
            return (T)Short.valueOf(value);
        }
        if (Byte.class.equals(type)) {
            return (T)Byte.valueOf(value);
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(value);
        }
        if (Character.class.equals(type)) {
            return (T)Character.valueOf(value.length() != 0 ? value.charAt(0) : (char)'\u0000');
        }
        if (String.class.equals(type)) {
            return (T)value;
        }
        throw new IllegalArgumentException(Errors.format(187, type));
    }

    public static String getShortName(Class<?> classe) {
        if (classe == null) {
            return "<*>";
        }
        String name = classe.getSimpleName();
        Class<?> enclosing = classe.getEnclosingClass();
        if (enclosing != null) {
            StringBuilder buffer = new StringBuilder();
            do {
                buffer.insert(0, '.').insert(0, enclosing.getSimpleName());
            } while ((enclosing = enclosing.getEnclosingClass()) != null);
            name = buffer.append(name).toString();
        }
        return name;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    static {
        new Classes(Double.TYPE, Double.class, true, false, 64, 8);
        new Classes(Float.TYPE, Float.class, true, false, 32, 7);
        new Classes(Long.TYPE, Long.class, false, true, 64, 6);
        new Classes(Integer.TYPE, Integer.class, false, true, 32, 5);
        new Classes(Short.TYPE, Short.class, false, true, 16, 4);
        new Classes(Byte.TYPE, Byte.class, false, true, 8, 3);
        new Classes(Character.TYPE, Character.class, false, false, 16, 2);
        new Classes(Boolean.TYPE, Boolean.class, false, false, 1, 1);
        new Classes(Void.TYPE, Void.class, false, false, 0, 0);
    }
}

