/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.index.quadtree.IndexStore;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemNode;
import org.geotools.index.quadtree.fs.IndexHeader;
import org.geotools.util.logging.Logging;

public class FileSystemIndexStore
implements IndexStore {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private File file;

    public FileSystemIndexStore(File file) {
        this.file = file;
    }

    @Override
    public QuadTree load(IndexFile indexfile, boolean useMemoryMapping) throws StoreException {
        QuadTree tree = null;
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Opening QuadTree " + this.file.getCanonicalPath());
            }
            final FileInputStream fis = new FileInputStream(this.file);
            final FileChannel channel = fis.getChannel();
            IndexHeader header = new IndexHeader(channel);
            ByteOrder order = FileSystemIndexStore.byteToOrder(header.getByteOrder());
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(order);
            channel.read(buf);
            buf.flip();
            tree = new QuadTree(buf.getInt(), buf.getInt(), indexfile){

                @Override
                public void insert(int recno, Envelope bounds) {
                    throw new UnsupportedOperationException("File quadtrees are immutable");
                }

                @Override
                public boolean trim() {
                    return false;
                }

                @Override
                public void close() throws StoreException {
                    super.close();
                    try {
                        channel.close();
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new StoreException(e);
                    }
                }
            };
            tree.setRoot(FileSystemNode.readNode(0, null, channel, order, useMemoryMapping));
            LOGGER.finest("QuadTree opened");
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        return tree;
    }

    private static ByteOrder byteToOrder(byte order) {
        ByteOrder ret = null;
        switch (order) {
            case 0: {
                ret = ByteOrder.nativeOrder();
                break;
            }
            case -1: 
            case 1: {
                ret = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case -2: 
            case 2: {
                ret = ByteOrder.BIG_ENDIAN;
            }
        }
        return ret;
    }
}

