/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class DuplicatingFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    protected final FilterFactory2 ff;

    public DuplicatingFilterVisitor() {
        this(CommonFactoryFinder.getFilterFactory2(GeoTools.getDefaultHints()));
    }

    public DuplicatingFilterVisitor(FilterFactory2 factory) {
        this.ff = factory;
    }

    protected FilterFactory2 getFactory(Object extraData) {
        if (extraData instanceof FilterFactory2) {
            return (FilterFactory2)extraData;
        }
        return this.ff;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object extraData) {
        return filter;
    }

    @Override
    public Object visit(IncludeFilter filter, Object extraData) {
        return filter;
    }

    Expression visit(Expression expression, Object extraData) {
        if (expression == null) {
            return null;
        }
        return (Expression)expression.accept(this, extraData);
    }

    @Override
    public Object visit(And filter, Object extraData) {
        List<Filter> children = filter.getChildren();
        ArrayList<Filter> newChildren = new ArrayList<Filter>();
        for (Filter child : children) {
            if (child == null) continue;
            newChildren.add((Filter)child.accept(this, extraData));
        }
        return this.getFactory(extraData).and(newChildren);
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        return this.getFactory(extraData).id(filter.getIdentifiers());
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        return this.getFactory(extraData).not((Filter)filter.getFilter().accept(this, extraData));
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        List<Filter> children = filter.getChildren();
        ArrayList<Filter> newChildren = new ArrayList<Filter>();
        for (Filter child : children) {
            if (child == null) continue;
            newChildren.add((Filter)child.accept(this, extraData));
        }
        return this.getFactory(extraData).or(newChildren);
    }

    @Override
    public Object visit(NilExpression expression, Object extraData) {
        return expression;
    }

    @Override
    public Object visit(Add expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).add(expr1, expr2);
    }

    @Override
    public Object visit(Divide expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).divide(expr1, expr2);
    }

    @Override
    public Object visit(Function expression, Object extraData) {
        List<Expression> old = expression.getParameters();
        Expression[] args = new Expression[old.size()];
        int i = 0;
        for (Expression exp : old) {
            args[i] = this.visit(exp, extraData);
            ++i;
        }
        return this.getFactory(extraData).function(expression.getName(), args);
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        return this.getFactory(extraData).literal(expression.getValue());
    }

    @Override
    public Object visit(Multiply expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).multiply(expr1, expr2);
    }

    @Override
    public Object visit(PropertyName expression, Object extraData) {
        return this.getFactory(extraData).property(expression.getPropertyName(), expression.getNamespaceContext());
    }

    @Override
    public Object visit(Subtract expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).subtract(expr1, expr2);
    }
}

