/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.factory.Hints;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.Name;

public class DirectPropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor DIRECT = new DirectPropertyAccessor();

    @Override
    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        return DIRECT;
    }

    static class DirectPropertyAccessor
    implements PropertyAccessor {
        DirectPropertyAccessor() {
        }

        @Override
        public boolean canHandle(Object object, String xpath, Class target) {
            if (object instanceof Property) {
                Property property = (Property)object;
                Name name = property.getName();
                if (name != null) {
                    return name.getLocalPart().equals(xpath);
                }
                return false;
            }
            return false;
        }

        @Override
        public Object get(Object object, String xpath, Class target) throws IllegalArgumentException {
            return ((Property)object).getValue();
        }
    }
}

